/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.request.context;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadTimer {
    private static final ThreadMXBean MX_BEAN = ManagementFactory.getThreadMXBean();
    private static final boolean IS_CURRENT_THREAD_CPU_TIME_SUPPORTED = MX_BEAN.isCurrentThreadCpuTimeSupported();
    private static final Logger LOGGER = LoggerFactory.getLogger(ThreadTimer.class);
    private static boolean IS_THREAD_CPU_TIME_MEASUREMENT_ENABLED = false;
    private long _startTimeNs = -1L;
    private long _endTimeNs = -1L;

    public static void setThreadCpuTimeMeasurementEnabled(boolean enable) {
        IS_THREAD_CPU_TIME_MEASUREMENT_ENABLED = enable && IS_CURRENT_THREAD_CPU_TIME_SUPPORTED;
    }

    public void start() {
        if (IS_THREAD_CPU_TIME_MEASUREMENT_ENABLED) {
            this._startTimeNs = MX_BEAN.getCurrentThreadCpuTime();
        }
    }

    public void stop() {
        if (IS_THREAD_CPU_TIME_MEASUREMENT_ENABLED) {
            this._endTimeNs = MX_BEAN.getCurrentThreadCpuTime();
        }
    }

    public long getThreadTimeNs() {
        return this._endTimeNs - this._startTimeNs;
    }

    public long stopAndGetThreadTimeNs() {
        this.stop();
        return this.getThreadTimeNs();
    }

    static {
        LOGGER.info("Current thread cpu time measurement supported: {}", (Object)IS_CURRENT_THREAD_CPU_TIME_SUPPORTED);
    }
}

