/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.request.context.utils;

import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.query.request.context.utils.BrokerRequestToQueryContextConverter;
import org.apache.pinot.pql.parsers.Pql2Compiler;
import org.apache.pinot.sql.parsers.CalciteSqlCompiler;

public class QueryContextConverterUtils {
    private static final Pql2Compiler PQL_COMPILER = new Pql2Compiler();
    private static final CalciteSqlCompiler SQL_COMPILER = new CalciteSqlCompiler();

    private QueryContextConverterUtils() {
    }

    public static QueryContext getQueryContextFromPQL(String pqlQuery) {
        return BrokerRequestToQueryContextConverter.convert(PQL_COMPILER.compileToBrokerRequest(pqlQuery));
    }

    public static QueryContext getQueryContextFromSQL(String sqlQuery) {
        return BrokerRequestToQueryContextConverter.convert(SQL_COMPILER.compileToBrokerRequest(sqlQuery));
    }
}

