/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.request.context.utils;

import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.aggregation.function.DistinctAggregationFunction;
import org.apache.pinot.core.query.request.context.QueryContext;

public class QueryContextUtils {
    private QueryContextUtils() {
    }

    public static boolean isSelectionQuery(QueryContext query) {
        return query.getAggregationFunctions() == null;
    }

    public static boolean isAggregationQuery(QueryContext query) {
        AggregationFunction[] aggregationFunctions = query.getAggregationFunctions();
        return aggregationFunctions != null && (aggregationFunctions.length != 1 || !(aggregationFunctions[0] instanceof DistinctAggregationFunction));
    }

    public static boolean isDistinctQuery(QueryContext query) {
        AggregationFunction[] aggregationFunctions = query.getAggregationFunctions();
        return aggregationFunctions != null && aggregationFunctions.length == 1 && aggregationFunctions[0] instanceof DistinctAggregationFunction;
    }
}

