/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.processing.aggregator;

import org.apache.pinot.core.segment.processing.aggregator.ValueAggregator;
import org.apache.pinot.spi.data.FieldSpec;

public class MinValueAggregator
implements ValueAggregator {
    private final FieldSpec.DataType _dataType;

    public MinValueAggregator(FieldSpec.DataType dataType) {
        this._dataType = dataType;
    }

    @Override
    public Object aggregate(Object value1, Object value2) {
        Number result;
        switch (this._dataType) {
            case INT: {
                result = Math.min(((Number)value1).intValue(), ((Number)value2).intValue());
                break;
            }
            case LONG: {
                result = Math.min(((Number)value1).longValue(), ((Number)value2).longValue());
                break;
            }
            case FLOAT: {
                result = Float.valueOf(Math.min(((Number)value1).floatValue(), ((Number)value2).floatValue()));
                break;
            }
            case DOUBLE: {
                result = Math.min(((Number)value1).doubleValue(), ((Number)value2).doubleValue());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported metric type : " + this._dataType);
            }
        }
        return result;
    }
}

