/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.processing.framework;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.pinot.common.utils.TarGzCompressionUtils;
import org.apache.pinot.core.segment.processing.framework.SegmentProcessorConfig;
import org.apache.pinot.core.segment.processing.genericrow.GenericRowFileManager;
import org.apache.pinot.core.segment.processing.genericrow.GenericRowFileReader;
import org.apache.pinot.core.segment.processing.genericrow.GenericRowFileRecordReader;
import org.apache.pinot.core.segment.processing.mapper.SegmentMapper;
import org.apache.pinot.core.segment.processing.reducer.Reducer;
import org.apache.pinot.core.segment.processing.reducer.ReducerFactory;
import org.apache.pinot.segment.local.recordtransformer.CompositeTransformer;
import org.apache.pinot.segment.local.recordtransformer.RecordTransformer;
import org.apache.pinot.segment.local.segment.creator.RecordReaderSegmentCreationDataSource;
import org.apache.pinot.segment.local.segment.creator.impl.SegmentIndexCreationDriverImpl;
import org.apache.pinot.segment.local.segment.readers.PinotSegmentRecordReader;
import org.apache.pinot.segment.spi.creator.SegmentCreationDataSource;
import org.apache.pinot.segment.spi.creator.SegmentGeneratorConfig;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.data.readers.RecordReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentProcessorFramework {
    private static final Logger LOGGER = LoggerFactory.getLogger(SegmentProcessorFramework.class);
    private final File _inputSegmentsDir;
    private final File _outputSegmentsDir;
    private final SegmentProcessorConfig _segmentProcessorConfig;
    private final TableConfig _tableConfig;
    private final Schema _schema;
    private final File _baseDir;
    private final File _mapperInputDir;
    private final File _mapperOutputDir;
    private final File _reducerOutputDir;

    public SegmentProcessorFramework(File inputSegmentsDir, SegmentProcessorConfig segmentProcessorConfig, File outputSegmentsDir) {
        LOGGER.info("Initializing SegmentProcessorFramework with input segments dir: {}, output segments dir: {} and segment processor config: {}", new Object[]{inputSegmentsDir.getAbsolutePath(), outputSegmentsDir.getAbsolutePath(), segmentProcessorConfig.toString()});
        this._inputSegmentsDir = inputSegmentsDir;
        Preconditions.checkState((this._inputSegmentsDir.exists() && this._inputSegmentsDir.isDirectory() ? 1 : 0) != 0, (String)"Input path: %s must be a directory with Pinot segments", (Object)this._inputSegmentsDir.getAbsolutePath());
        this._outputSegmentsDir = outputSegmentsDir;
        Preconditions.checkState((this._outputSegmentsDir.exists() && this._outputSegmentsDir.isDirectory() && this._outputSegmentsDir.list().length == 0 ? 1 : 0) != 0, (String)"Must provide existing empty output directory: %s", (Object)this._outputSegmentsDir.getAbsolutePath());
        this._segmentProcessorConfig = segmentProcessorConfig;
        this._tableConfig = segmentProcessorConfig.getTableConfig();
        this._schema = segmentProcessorConfig.getSchema();
        this._baseDir = new File(FileUtils.getTempDirectory(), "segment_processor_" + System.currentTimeMillis());
        FileUtils.deleteQuietly((File)this._baseDir);
        Preconditions.checkState((boolean)this._baseDir.mkdirs(), (String)"Failed to create base directory: %s for SegmentProcessor", (Object)this._baseDir);
        this._mapperInputDir = new File(this._baseDir, "mapper_input");
        Preconditions.checkState((boolean)this._mapperInputDir.mkdirs(), (String)"Failed to create mapper input directory: %s for SegmentProcessor", (Object)this._mapperInputDir);
        this._mapperOutputDir = new File(this._baseDir, "mapper_output");
        Preconditions.checkState((boolean)this._mapperOutputDir.mkdirs(), (String)"Failed to create mapper output directory: %s for SegmentProcessor", (Object)this._mapperOutputDir);
        this._reducerOutputDir = new File(this._baseDir, "reducer_output");
        Preconditions.checkState((boolean)this._reducerOutputDir.mkdirs(), (String)"Failed to create reducer output directory: %s for SegmentProcessor", (Object)this._reducerOutputDir);
    }

    /*
     * WARNING - void declaration
     */
    public void processSegments() throws Exception {
        File[] segmentFiles = this._inputSegmentsDir.listFiles();
        Preconditions.checkState((segmentFiles != null && segmentFiles.length > 0 ? 1 : 0) != 0, (String)"Failed to find segments under input dir: %s", (Object)this._inputSegmentsDir.getAbsolutePath());
        LOGGER.info("Beginning map phase on segments: {}", (Object)Arrays.toString(this._inputSegmentsDir.list()));
        ArrayList<RecordReader> recordReaders = new ArrayList<RecordReader>(segmentFiles.length);
        for (File file : segmentFiles) {
            void var6_8;
            String fileName = file.getName();
            if (!file.isDirectory()) {
                if (fileName.endsWith(".tar.gz") || fileName.endsWith(".tgz")) {
                    File file2 = (File)TarGzCompressionUtils.untar((File)file, (File)this._mapperInputDir).get(0);
                } else {
                    throw new IllegalStateException("Unsupported segment format: " + file.getAbsolutePath());
                }
            }
            PinotSegmentRecordReader recordReader = new PinotSegmentRecordReader();
            recordReader.init((File)var6_8, null, null, true);
            recordReaders.add((RecordReader)recordReader);
        }
        SegmentMapper mapper = new SegmentMapper(recordReaders, this._segmentProcessorConfig, this._mapperOutputDir);
        Map<String, GenericRowFileManager> partitionToFileManagerMap = mapper.map();
        for (RecordReader recordReader : recordReaders) {
            recordReader.close();
        }
        FileUtils.deleteDirectory((File)this._mapperInputDir);
        if (partitionToFileManagerMap.isEmpty()) {
            LOGGER.info("No partition generated from mapper phase, skipping the reducer phase");
            return;
        }
        LOGGER.info("Beginning reduce phase on partitions: {}", partitionToFileManagerMap.keySet());
        for (Map.Entry entry : partitionToFileManagerMap.entrySet()) {
            String partitionId = (String)entry.getKey();
            GenericRowFileManager fileManager = (GenericRowFileManager)entry.getValue();
            Reducer reducer = ReducerFactory.getReducer(partitionId, fileManager, this._segmentProcessorConfig, this._reducerOutputDir);
            entry.setValue(reducer.reduce());
        }
        LOGGER.info("Beginning segment creation phase on partitions: {}", partitionToFileManagerMap.keySet());
        SegmentGeneratorConfig generatorConfig = new SegmentGeneratorConfig(this._tableConfig, this._schema);
        generatorConfig.setOutDir(this._outputSegmentsDir.getPath());
        generatorConfig.setSegmentNamePrefix(this._segmentProcessorConfig.getSegmentConfig().getSegmentNamePrefix());
        int n = this._segmentProcessorConfig.getSegmentConfig().getMaxNumRecordsPerSegment();
        CompositeTransformer passThroughTransformer = CompositeTransformer.getPassThroughTransformer();
        int sequenceId = 0;
        for (Map.Entry<String, GenericRowFileManager> entry : partitionToFileManagerMap.entrySet()) {
            String partitionId = entry.getKey();
            GenericRowFileManager fileManager = entry.getValue();
            GenericRowFileReader fileReader = fileManager.getFileReader();
            int numRows = fileReader.getNumRows();
            int numSortFields = fileReader.getNumSortFields();
            LOGGER.info("Start creating segments on partition: {}, numRows: {}, numSortFields: {}", new Object[]{partitionId, numRows, numSortFields});
            GenericRowFileRecordReader recordReader = fileReader.getRecordReader();
            int startRowId = 0;
            while (startRowId < numRows) {
                int endRowId = Math.min(startRowId + n, numRows);
                LOGGER.info("Start creating segment of sequenceId: {} with row range: {} to {}", new Object[]{sequenceId, startRowId, endRowId});
                generatorConfig.setSequenceId(sequenceId);
                GenericRowFileRecordReader recordReaderForRange = recordReader.getRecordReaderForRange(startRowId, endRowId);
                SegmentIndexCreationDriverImpl driver = new SegmentIndexCreationDriverImpl();
                driver.init(generatorConfig, (SegmentCreationDataSource)new RecordReaderSegmentCreationDataSource((RecordReader)recordReaderForRange), (RecordTransformer)passThroughTransformer, null);
                driver.build();
                startRowId += n;
                ++sequenceId;
            }
            fileManager.cleanUp();
        }
        LOGGER.info("Successfully converted segments from: {} to {}", (Object)Arrays.toString(this._inputSegmentsDir.list()), (Object)Arrays.toString(this._outputSegmentsDir.list()));
    }

    public void cleanup() {
        FileUtils.deleteQuietly((File)this._baseDir);
    }
}

