/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.processing.genericrow;

import java.util.List;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.utils.ByteArray;
import org.apache.pinot.spi.utils.StringUtils;

public class GenericRowDeserializer {
    private final PinotDataBuffer _dataBuffer;
    private final int _numFields;
    private final String[] _fieldNames;
    private final boolean[] _isSingleValueFields;
    private final FieldSpec.DataType[] _storedTypes;
    private final boolean _includeNullFields;

    public GenericRowDeserializer(PinotDataBuffer dataBuffer, List<FieldSpec> fieldSpecs, boolean includeNullFields) {
        this._dataBuffer = dataBuffer;
        this._numFields = fieldSpecs.size();
        this._fieldNames = new String[this._numFields];
        this._isSingleValueFields = new boolean[this._numFields];
        this._storedTypes = new FieldSpec.DataType[this._numFields];
        for (int i = 0; i < this._numFields; ++i) {
            FieldSpec fieldSpec = fieldSpecs.get(i);
            this._fieldNames[i] = fieldSpec.getName();
            this._isSingleValueFields[i] = fieldSpec.isSingleValueField();
            this._storedTypes[i] = fieldSpec.getDataType().getStoredType();
        }
        this._includeNullFields = includeNullFields;
    }

    public void deserialize(long offset, GenericRow buffer) {
        block15: for (int i = 0; i < this._numFields; ++i) {
            String fieldName = this._fieldNames[i];
            if (this._isSingleValueFields[i]) {
                switch (this._storedTypes[i]) {
                    case INT: {
                        buffer.putValue(fieldName, (Object)this._dataBuffer.getInt(offset));
                        offset += 4L;
                        continue block15;
                    }
                    case LONG: {
                        buffer.putValue(fieldName, (Object)this._dataBuffer.getLong(offset));
                        offset += 8L;
                        continue block15;
                    }
                    case FLOAT: {
                        buffer.putValue(fieldName, (Object)Float.valueOf(this._dataBuffer.getFloat(offset)));
                        offset += 4L;
                        continue block15;
                    }
                    case DOUBLE: {
                        buffer.putValue(fieldName, (Object)this._dataBuffer.getDouble(offset));
                        offset += 8L;
                        continue block15;
                    }
                    case STRING: {
                        int numBytes = this._dataBuffer.getInt(offset);
                        byte[] stringBytes = new byte[numBytes];
                        this._dataBuffer.copyTo(offset += 4L, stringBytes);
                        offset += (long)numBytes;
                        buffer.putValue(fieldName, (Object)StringUtils.decodeUtf8((byte[])stringBytes));
                        continue block15;
                    }
                    case BYTES: {
                        int numBytes = this._dataBuffer.getInt(offset);
                        byte[] bytes = new byte[numBytes];
                        this._dataBuffer.copyTo(offset += 4L, bytes);
                        offset += (long)numBytes;
                        buffer.putValue(fieldName, (Object)bytes);
                        continue block15;
                    }
                    default: {
                        throw new IllegalStateException("Unsupported SV stored type: " + this._storedTypes[i]);
                    }
                }
            }
            int numValues = this._dataBuffer.getInt(offset);
            offset += 4L;
            Object[] multiValue = new Object[numValues];
            switch (this._storedTypes[i]) {
                case INT: {
                    int j;
                    for (j = 0; j < numValues; ++j) {
                        multiValue[j] = this._dataBuffer.getInt(offset);
                        offset += 4L;
                    }
                    break;
                }
                case LONG: {
                    int j;
                    for (j = 0; j < numValues; ++j) {
                        multiValue[j] = this._dataBuffer.getLong(offset);
                        offset += 8L;
                    }
                    break;
                }
                case FLOAT: {
                    int j;
                    for (j = 0; j < numValues; ++j) {
                        multiValue[j] = Float.valueOf(this._dataBuffer.getFloat(offset));
                        offset += 4L;
                    }
                    break;
                }
                case DOUBLE: {
                    int j;
                    for (j = 0; j < numValues; ++j) {
                        multiValue[j] = this._dataBuffer.getDouble(offset);
                        offset += 8L;
                    }
                    break;
                }
                case STRING: {
                    int j;
                    for (j = 0; j < numValues; ++j) {
                        int numBytes = this._dataBuffer.getInt(offset);
                        byte[] stringBytes = new byte[numBytes];
                        this._dataBuffer.copyTo(offset += 4L, stringBytes);
                        offset += (long)numBytes;
                        multiValue[j] = StringUtils.decodeUtf8((byte[])stringBytes);
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported MV stored type: " + this._storedTypes[i]);
                }
            }
            buffer.putValue(fieldName, (Object)multiValue);
        }
        if (this._includeNullFields) {
            int numNullFields = this._dataBuffer.getInt(offset);
            offset += 4L;
            for (int i = 0; i < numNullFields; ++i) {
                buffer.addNullValueField(this._fieldNames[this._dataBuffer.getInt(offset)]);
                offset += 4L;
            }
        }
    }

    public int compare(long offset1, long offset2, int numFieldsToCompare) {
        block15: for (int i = 0; i < numFieldsToCompare; ++i) {
            int numValues2;
            if (this._isSingleValueFields[i]) {
                switch (this._storedTypes[i]) {
                    case INT: {
                        int result = Integer.compare(this._dataBuffer.getInt(offset1), this._dataBuffer.getInt(offset2));
                        if (result != 0) {
                            return result;
                        }
                        offset1 += 4L;
                        offset2 += 4L;
                        continue block15;
                    }
                    case LONG: {
                        int result = Long.compare(this._dataBuffer.getLong(offset1), this._dataBuffer.getLong(offset2));
                        if (result != 0) {
                            return result;
                        }
                        offset1 += 8L;
                        offset2 += 8L;
                        continue block15;
                    }
                    case FLOAT: {
                        int result = Float.compare(this._dataBuffer.getFloat(offset1), this._dataBuffer.getFloat(offset2));
                        if (result != 0) {
                            return result;
                        }
                        offset1 += 4L;
                        offset2 += 4L;
                        continue block15;
                    }
                    case DOUBLE: {
                        int result = Double.compare(this._dataBuffer.getDouble(offset1), this._dataBuffer.getDouble(offset2));
                        if (result != 0) {
                            return result;
                        }
                        offset1 += 8L;
                        offset2 += 8L;
                        continue block15;
                    }
                    case STRING: {
                        int numBytes1 = this._dataBuffer.getInt(offset1);
                        byte[] stringBytes1 = new byte[numBytes1];
                        this._dataBuffer.copyTo(offset1 += 4L, stringBytes1);
                        int numBytes2 = this._dataBuffer.getInt(offset2);
                        byte[] stringBytes2 = new byte[numBytes2];
                        this._dataBuffer.copyTo(offset2 += 4L, stringBytes2);
                        int result = StringUtils.decodeUtf8((byte[])stringBytes1).compareTo(StringUtils.decodeUtf8((byte[])stringBytes2));
                        if (result != 0) {
                            return result;
                        }
                        offset1 += (long)numBytes1;
                        offset2 += (long)numBytes2;
                        continue block15;
                    }
                    case BYTES: {
                        int numBytes1 = this._dataBuffer.getInt(offset1);
                        byte[] bytes1 = new byte[numBytes1];
                        this._dataBuffer.copyTo(offset1 += 4L, bytes1);
                        int numBytes2 = this._dataBuffer.getInt(offset2);
                        byte[] bytes2 = new byte[numBytes2];
                        this._dataBuffer.copyTo(offset2 += 4L, bytes2);
                        int result = ByteArray.compare((byte[])bytes1, (byte[])bytes2);
                        if (result != 0) {
                            return result;
                        }
                        offset1 += (long)numBytes1;
                        offset2 += (long)numBytes2;
                        continue block15;
                    }
                    default: {
                        throw new IllegalStateException("Unsupported SV stored type: " + this._storedTypes[i]);
                    }
                }
            }
            int numValues = this._dataBuffer.getInt(offset1);
            if (numValues != (numValues2 = this._dataBuffer.getInt(offset2))) {
                return Integer.compare(numValues, numValues2);
            }
            offset1 += 4L;
            offset2 += 4L;
            switch (this._storedTypes[i]) {
                case INT: {
                    int j;
                    for (j = 0; j < numValues; ++j) {
                        int result = Integer.compare(this._dataBuffer.getInt(offset1), this._dataBuffer.getInt(offset2));
                        if (result != 0) {
                            return result;
                        }
                        offset1 += 4L;
                        offset2 += 4L;
                    }
                    continue block15;
                }
                case LONG: {
                    int j;
                    for (j = 0; j < numValues; ++j) {
                        int result = Long.compare(this._dataBuffer.getLong(offset1), this._dataBuffer.getLong(offset2));
                        if (result != 0) {
                            return result;
                        }
                        offset1 += 8L;
                        offset2 += 8L;
                    }
                    continue block15;
                }
                case FLOAT: {
                    int j;
                    for (j = 0; j < numValues; ++j) {
                        int result = Float.compare(this._dataBuffer.getFloat(offset1), this._dataBuffer.getFloat(offset2));
                        if (result != 0) {
                            return result;
                        }
                        offset1 += 4L;
                        offset2 += 4L;
                    }
                    continue block15;
                }
                case DOUBLE: {
                    int j;
                    for (j = 0; j < numValues; ++j) {
                        int result = Double.compare(this._dataBuffer.getDouble(offset1), this._dataBuffer.getDouble(offset2));
                        if (result != 0) {
                            return result;
                        }
                        offset1 += 8L;
                        offset2 += 8L;
                    }
                    continue block15;
                }
                case STRING: {
                    int j;
                    for (j = 0; j < numValues; ++j) {
                        int numBytes1 = this._dataBuffer.getInt(offset1);
                        byte[] stringBytes1 = new byte[numBytes1];
                        this._dataBuffer.copyTo(offset1 += 4L, stringBytes1);
                        int numBytes2 = this._dataBuffer.getInt(offset2);
                        byte[] stringBytes2 = new byte[numBytes2];
                        this._dataBuffer.copyTo(offset2 += 4L, stringBytes2);
                        int result = StringUtils.decodeUtf8((byte[])stringBytes1).compareTo(StringUtils.decodeUtf8((byte[])stringBytes2));
                        if (result != 0) {
                            return result;
                        }
                        offset1 += (long)numBytes1;
                        offset2 += (long)numBytes2;
                    }
                    continue block15;
                }
                default: {
                    throw new IllegalStateException("Unsupported MV stored type: " + this._storedTypes[i]);
                }
            }
        }
        return 0;
    }
}

