/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.processing.partitioner;

import org.apache.pinot.core.segment.processing.partitioner.Partitioner;
import org.apache.pinot.spi.data.readers.GenericRow;

public class RoundRobinPartitioner
implements Partitioner {
    private final int _numPartitions;
    private transient int _nextPartition = 0;

    public RoundRobinPartitioner(int numPartitions) {
        this._numPartitions = numPartitions;
    }

    @Override
    public String getPartition(GenericRow genericRow) {
        int currentPartition = this._nextPartition;
        this._nextPartition = (this._nextPartition + 1) % this._numPartitions;
        return String.valueOf(currentPartition);
    }
}

