/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.processing.reducer;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.pinot.core.segment.processing.aggregator.ValueAggregator;
import org.apache.pinot.core.segment.processing.aggregator.ValueAggregatorFactory;
import org.apache.pinot.core.segment.processing.genericrow.GenericRowFileManager;
import org.apache.pinot.core.segment.processing.genericrow.GenericRowFileReader;
import org.apache.pinot.core.segment.processing.genericrow.GenericRowFileRecordReader;
import org.apache.pinot.core.segment.processing.genericrow.GenericRowFileWriter;
import org.apache.pinot.core.segment.processing.reducer.Reducer;
import org.apache.pinot.segment.spi.AggregationFunctionType;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RollupReducer
implements Reducer {
    private static final Logger LOGGER = LoggerFactory.getLogger(RollupReducer.class);
    private static final AggregationFunctionType DEFAULT_AGGREGATOR_TYPE = AggregationFunctionType.SUM;
    private final String _partitionId;
    private final GenericRowFileManager _fileManager;
    private final Map<String, AggregationFunctionType> _aggregationTypes;
    private final File _reducerOutputDir;

    public RollupReducer(String partitionId, GenericRowFileManager fileManager, Map<String, AggregationFunctionType> aggregationTypes, File reducerOutputDir) {
        this._partitionId = partitionId;
        this._fileManager = fileManager;
        this._aggregationTypes = aggregationTypes;
        this._reducerOutputDir = reducerOutputDir;
    }

    @Override
    public GenericRowFileManager reduce() throws Exception {
        LOGGER.info("Start reducing on partition: {}", (Object)this._partitionId);
        long reduceStartTimeMs = System.currentTimeMillis();
        GenericRowFileReader fileReader = this._fileManager.getFileReader();
        int numRows = fileReader.getNumRows();
        int numSortFields = fileReader.getNumSortFields();
        LOGGER.info("Start sorting on numRows: {}, numSortFields: {}", (Object)numRows, (Object)numSortFields);
        long sortStartTimeMs = System.currentTimeMillis();
        GenericRowFileRecordReader recordReader = fileReader.getRecordReader();
        LOGGER.info("Finish sorting in {}ms", (Object)(System.currentTimeMillis() - sortStartTimeMs));
        List<FieldSpec> fieldSpecs = this._fileManager.getFieldSpecs();
        boolean includeNullFields = this._fileManager.isIncludeNullFields();
        ArrayList<AggregatorContext> aggregatorContextList = new ArrayList<AggregatorContext>();
        for (FieldSpec fieldSpec : fieldSpecs) {
            if (fieldSpec.getFieldType() != FieldSpec.FieldType.METRIC) continue;
            aggregatorContextList.add(new AggregatorContext(fieldSpec, this._aggregationTypes.getOrDefault(fieldSpec.getName(), DEFAULT_AGGREGATOR_TYPE)));
        }
        File partitionOutputDir = new File(this._reducerOutputDir, this._partitionId);
        FileUtils.forceMkdir((File)partitionOutputDir);
        LOGGER.info("Start creating rollup file under dir: {}", (Object)partitionOutputDir);
        long rollupFileCreationStartTimeMs = System.currentTimeMillis();
        GenericRowFileManager rollupFileManager = new GenericRowFileManager(partitionOutputDir, fieldSpecs, includeNullFields, 0);
        GenericRowFileWriter rollupFileWriter = rollupFileManager.getFileWriter();
        GenericRow previousRow = new GenericRow();
        recordReader.read(0, previousRow);
        int previousRowId = 0;
        GenericRow buffer = new GenericRow();
        if (includeNullFields) {
            for (int i = 1; i < numRows; ++i) {
                buffer.clear();
                recordReader.read(i, buffer);
                if (recordReader.compare(previousRowId, i) == 0) {
                    RollupReducer.aggregateWithNullFields(previousRow, buffer, aggregatorContextList);
                    continue;
                }
                rollupFileWriter.write(previousRow);
                previousRowId = i;
                GenericRow temp = previousRow;
                previousRow = buffer;
                buffer = temp;
            }
        } else {
            for (int i = 1; i < numRows; ++i) {
                buffer.clear();
                recordReader.read(i, buffer);
                if (recordReader.compare(previousRowId, i) == 0) {
                    RollupReducer.aggregateWithoutNullFields(previousRow, buffer, aggregatorContextList);
                    continue;
                }
                rollupFileWriter.write(previousRow);
                previousRowId = i;
                GenericRow temp = previousRow;
                previousRow = buffer;
                buffer = temp;
            }
        }
        rollupFileWriter.write(previousRow);
        rollupFileManager.closeFileWriter();
        LOGGER.info("Finish creating rollup file in {}ms", (Object)(System.currentTimeMillis() - rollupFileCreationStartTimeMs));
        this._fileManager.cleanUp();
        LOGGER.info("Finish reducing in {}ms", (Object)(System.currentTimeMillis() - reduceStartTimeMs));
        return rollupFileManager;
    }

    private static void aggregateWithNullFields(GenericRow aggregatedRow, GenericRow rowToAggregate, List<AggregatorContext> aggregatorContextList) {
        for (AggregatorContext aggregatorContext : aggregatorContextList) {
            String column = aggregatorContext._column;
            if (rowToAggregate.isNullValue(column)) continue;
            if (aggregatedRow.removeNullValueField(column)) {
                aggregatedRow.putValue(column, rowToAggregate.getValue(column));
                continue;
            }
            aggregatedRow.putValue(column, aggregatorContext._aggregator.aggregate(aggregatedRow.getValue(column), rowToAggregate.getValue(column)));
        }
    }

    private static void aggregateWithoutNullFields(GenericRow aggregatedRow, GenericRow rowToAggregate, List<AggregatorContext> aggregatorContextList) {
        for (AggregatorContext aggregatorContext : aggregatorContextList) {
            String column = aggregatorContext._column;
            aggregatedRow.putValue(column, aggregatorContext._aggregator.aggregate(aggregatedRow.getValue(column), rowToAggregate.getValue(column)));
        }
    }

    private static class AggregatorContext {
        final String _column;
        final ValueAggregator _aggregator;

        AggregatorContext(FieldSpec fieldSpec, AggregationFunctionType aggregationType) {
            this._column = fieldSpec.getName();
            this._aggregator = ValueAggregatorFactory.getValueAggregator(aggregationType, fieldSpec.getDataType());
        }
    }
}

