/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.startree.operator;

import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.pinot.core.operator.blocks.EmptyFilterBlock;
import org.apache.pinot.core.operator.blocks.FilterBlock;
import org.apache.pinot.core.operator.filter.BaseFilterOperator;
import org.apache.pinot.core.operator.filter.BitmapBasedFilterOperator;
import org.apache.pinot.core.operator.filter.EmptyFilterOperator;
import org.apache.pinot.core.operator.filter.FilterOperatorUtils;
import org.apache.pinot.core.operator.filter.predicate.PredicateEvaluator;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.segment.spi.index.startree.StarTree;
import org.apache.pinot.segment.spi.index.startree.StarTreeNode;
import org.apache.pinot.segment.spi.index.startree.StarTreeV2;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.roaringbitmap.buffer.MutableRoaringBitmap;

public class StarTreeFilterOperator
extends BaseFilterOperator {
    private static final String OPERATOR_NAME = "StarTreeFilterOperator";
    private static final int USE_SCAN_TO_TRAVERSE_NODES_THRESHOLD = 10;
    private final StarTreeV2 _starTreeV2;
    private final Map<String, List<PredicateEvaluator>> _predicateEvaluatorsMap;
    private final Set<String> _groupByColumns;
    private final Map<String, String> _debugOptions;
    boolean _resultEmpty = false;

    public StarTreeFilterOperator(StarTreeV2 starTreeV2, Map<String, List<PredicateEvaluator>> predicateEvaluatorsMap, Set<String> groupByColumns, @Nullable Map<String, String> debugOptions) {
        this._starTreeV2 = starTreeV2;
        this._predicateEvaluatorsMap = predicateEvaluatorsMap;
        this._debugOptions = debugOptions;
        if (groupByColumns != null) {
            this._groupByColumns = new HashSet<String>(groupByColumns);
            this._groupByColumns.removeAll(this._predicateEvaluatorsMap.keySet());
        } else {
            this._groupByColumns = Collections.emptySet();
        }
    }

    @Override
    public FilterBlock getNextBlock() {
        if (this._resultEmpty) {
            return EmptyFilterBlock.getInstance();
        }
        return (FilterBlock)this.getFilterOperator().nextBlock();
    }

    @Override
    public boolean isResultEmpty() {
        return this._resultEmpty;
    }

    @Override
    public String getOperatorName() {
        return OPERATOR_NAME;
    }

    private BaseFilterOperator getFilterOperator() {
        StarTreeResult starTreeResult = this.traverseStarTree();
        if (starTreeResult == null) {
            return EmptyFilterOperator.getInstance();
        }
        int numDocs = this._starTreeV2.getMetadata().getNumDocs();
        ArrayList<BaseFilterOperator> childFilterOperators = new ArrayList<BaseFilterOperator>(1 + starTreeResult._remainingPredicateColumns.size());
        childFilterOperators.add(new BitmapBasedFilterOperator(starTreeResult._matchedDocIds, false, numDocs));
        for (String remainingPredicateColumn : starTreeResult._remainingPredicateColumns) {
            List<PredicateEvaluator> predicateEvaluators = this._predicateEvaluatorsMap.get(remainingPredicateColumn);
            DataSource dataSource = this._starTreeV2.getDataSource(remainingPredicateColumn);
            for (PredicateEvaluator predicateEvaluator : predicateEvaluators) {
                childFilterOperators.add(FilterOperatorUtils.getLeafFilterOperator(predicateEvaluator, dataSource, numDocs));
            }
        }
        return FilterOperatorUtils.getAndFilterOperator(childFilterOperators, numDocs, this._debugOptions);
    }

    @Nullable
    private StarTreeResult traverseStarTree() {
        SearchEntry searchEntry;
        MutableRoaringBitmap matchingDocIds = new MutableRoaringBitmap();
        HashSet<String> remainingPredicateColumns = new HashSet<String>();
        HashMap<String, IntSet> matchingDictIdsMap = new HashMap<String, IntSet>();
        StarTree starTree = this._starTreeV2.getStarTree();
        List dimensionNames = starTree.getDimensionNames();
        StarTreeNode starTreeRootNode = starTree.getRoot();
        LinkedList<SearchEntry> queue = new LinkedList<SearchEntry>();
        queue.add(new SearchEntry(starTreeRootNode, this._predicateEvaluatorsMap.keySet(), this._groupByColumns));
        while ((searchEntry = (SearchEntry)queue.poll()) != null) {
            Set<String> newRemainingGroupByColumns;
            StarTreeNode starTreeNode = searchEntry._starTreeNode;
            if (searchEntry._remainingPredicateColumns.isEmpty() && searchEntry._remainingGroupByColumns.isEmpty()) {
                matchingDocIds.add(starTreeNode.getAggregatedDocId());
                continue;
            }
            if (starTreeNode.isLeaf()) {
                matchingDocIds.add((long)starTreeNode.getStartDocId(), (long)starTreeNode.getEndDocId());
                remainingPredicateColumns.addAll(searchEntry._remainingPredicateColumns);
                continue;
            }
            String nextDimension = (String)dimensionNames.get(starTreeNode.getChildDimensionId());
            if (searchEntry._remainingPredicateColumns.contains(nextDimension)) {
                int numChildren;
                int numMatchingDictIds;
                HashSet<String> newRemainingPredicateColumns = new HashSet<String>(searchEntry._remainingPredicateColumns);
                newRemainingPredicateColumns.remove(nextDimension);
                IntSet matchingDictIds = (IntSet)matchingDictIdsMap.get(nextDimension);
                if (matchingDictIds == null) {
                    matchingDictIds = this.getMatchingDictIds(this._predicateEvaluatorsMap.get(nextDimension));
                    if (matchingDictIds.isEmpty()) {
                        return null;
                    }
                    matchingDictIdsMap.put(nextDimension, matchingDictIds);
                }
                if ((numMatchingDictIds = matchingDictIds.size()) * 10 > (numChildren = starTreeNode.getNumChildren())) {
                    Iterator childrenIterator = starTreeNode.getChildrenIterator();
                    while (childrenIterator.hasNext()) {
                        StarTreeNode childNode = (StarTreeNode)childrenIterator.next();
                        if (!matchingDictIds.contains(childNode.getDimensionValue())) continue;
                        queue.add(new SearchEntry(childNode, newRemainingPredicateColumns, searchEntry._remainingGroupByColumns));
                    }
                    continue;
                }
                IntIterator iterator = matchingDictIds.iterator();
                while (iterator.hasNext()) {
                    int matchingDictId = iterator.nextInt();
                    StarTreeNode childNode = starTreeNode.getChildForDimensionValue(matchingDictId);
                    if (childNode == null) continue;
                    queue.add(new SearchEntry(childNode, newRemainingPredicateColumns, searchEntry._remainingGroupByColumns));
                }
                continue;
            }
            if (!searchEntry._remainingGroupByColumns.contains(nextDimension)) {
                StarTreeNode starNode = starTreeNode.getChildForDimensionValue(-1);
                if (starNode != null) {
                    queue.add(new SearchEntry(starNode, searchEntry._remainingPredicateColumns, searchEntry._remainingGroupByColumns));
                    continue;
                }
                newRemainingGroupByColumns = searchEntry._remainingGroupByColumns;
            } else {
                newRemainingGroupByColumns = new HashSet<String>(searchEntry._remainingGroupByColumns);
                newRemainingGroupByColumns.remove(nextDimension);
            }
            Iterator childrenIterator = starTreeNode.getChildrenIterator();
            while (childrenIterator.hasNext()) {
                StarTreeNode childNode = (StarTreeNode)childrenIterator.next();
                if (childNode.getDimensionValue() == -1) continue;
                queue.add(new SearchEntry(childNode, searchEntry._remainingPredicateColumns, newRemainingGroupByColumns));
            }
        }
        return new StarTreeResult((ImmutableRoaringBitmap)matchingDocIds, remainingPredicateColumns);
    }

    private IntSet getMatchingDictIds(List<PredicateEvaluator> predicateEvaluators) {
        predicateEvaluators.sort(new Comparator<PredicateEvaluator>(){

            @Override
            public int compare(PredicateEvaluator o1, PredicateEvaluator o2) {
                return this.getPriority(o1) - this.getPriority(o2);
            }

            int getPriority(PredicateEvaluator predicateEvaluator) {
                switch (predicateEvaluator.getPredicateType()) {
                    case EQ: {
                        return 1;
                    }
                    case IN: {
                        return 2;
                    }
                    case RANGE: {
                        return 3;
                    }
                    case NOT_EQ: 
                    case NOT_IN: {
                        return 4;
                    }
                }
                throw new UnsupportedOperationException();
            }
        });
        IntOpenHashSet matchingDictIds = new IntOpenHashSet();
        PredicateEvaluator firstPredicateEvaluator = predicateEvaluators.get(0);
        for (int matchingDictId : firstPredicateEvaluator.getMatchingDictIds()) {
            matchingDictIds.add(matchingDictId);
        }
        int numPredicateEvaluators = predicateEvaluators.size();
        for (int i = 1; i < numPredicateEvaluators; ++i) {
            if (matchingDictIds.isEmpty()) {
                return matchingDictIds;
            }
            PredicateEvaluator predicateEvaluator = predicateEvaluators.get(i);
            IntIterator iterator = matchingDictIds.iterator();
            while (iterator.hasNext()) {
                if (predicateEvaluator.applySV(iterator.nextInt())) continue;
                iterator.remove();
            }
        }
        return matchingDictIds;
    }

    private static class StarTreeResult {
        final ImmutableRoaringBitmap _matchedDocIds;
        final Set<String> _remainingPredicateColumns;

        StarTreeResult(ImmutableRoaringBitmap matchedDocIds, Set<String> remainingPredicateColumns) {
            this._matchedDocIds = matchedDocIds;
            this._remainingPredicateColumns = remainingPredicateColumns;
        }
    }

    private static class SearchEntry {
        final StarTreeNode _starTreeNode;
        final Set<String> _remainingPredicateColumns;
        final Set<String> _remainingGroupByColumns;

        SearchEntry(StarTreeNode starTreeNode, Set<String> remainingPredicateColumns, Set<String> remainingGroupByColumns) {
            this._starTreeNode = starTreeNode;
            this._remainingPredicateColumns = remainingPredicateColumns;
            this._remainingGroupByColumns = remainingGroupByColumns;
        }
    }
}

