/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.transport;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.MoreExecutors;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.pinot.common.exception.QueryException;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.ServerMeter;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.common.metrics.ServerQueryPhase;
import org.apache.pinot.common.metrics.ServerTimer;
import org.apache.pinot.common.request.InstanceRequest;
import org.apache.pinot.common.response.ProcessingException;
import org.apache.pinot.common.utils.DataTable;
import org.apache.pinot.core.common.datatable.DataTableBuilder;
import org.apache.pinot.core.query.request.ServerQueryRequest;
import org.apache.pinot.core.query.scheduler.QueryScheduler;
import org.apache.pinot.spi.utils.BytesUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TDeserializer;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceRequestHandler
extends SimpleChannelInboundHandler<ByteBuf> {
    private static final Logger LOGGER = LoggerFactory.getLogger(InstanceRequestHandler.class);
    private static final int SLOW_QUERY_LATENCY_THRESHOLD_MS = 100;
    private final TDeserializer _deserializer = new TDeserializer((TProtocolFactory)new TCompactProtocol.Factory());
    private final QueryScheduler _queryScheduler;
    private final ServerMetrics _serverMetrics;

    public InstanceRequestHandler(QueryScheduler queryScheduler, ServerMetrics serverMetrics) {
        this._queryScheduler = queryScheduler;
        this._serverMetrics = serverMetrics;
    }

    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) {
        long queryArrivalTimeMs = 0L;
        InstanceRequest instanceRequest = null;
        byte[] requestBytes = null;
        String tableNameWithType = null;
        try {
            int requestSize = msg.readableBytes();
            instanceRequest = new InstanceRequest();
            requestBytes = new byte[requestSize];
            queryArrivalTimeMs = System.currentTimeMillis();
            this._serverMetrics.addMeteredGlobalValue((AbstractMetrics.Meter)ServerMeter.QUERIES, 1L);
            this._serverMetrics.addMeteredGlobalValue((AbstractMetrics.Meter)ServerMeter.NETTY_CONNECTION_BYTES_RECEIVED, (long)requestSize);
            msg.readBytes(requestBytes);
            this._deserializer.deserialize((TBase)instanceRequest, requestBytes);
            ServerQueryRequest queryRequest = new ServerQueryRequest(instanceRequest, this._serverMetrics, queryArrivalTimeMs);
            queryRequest.getTimerContext().startNewPhaseTimer(ServerQueryPhase.REQUEST_DESERIALIZATION, queryArrivalTimeMs).stopAndRecord();
            tableNameWithType = queryRequest.getTableNameWithType();
            Futures.addCallback(this._queryScheduler.submit(queryRequest), this.createCallback(ctx, tableNameWithType, queryArrivalTimeMs, instanceRequest, queryRequest), (Executor)MoreExecutors.directExecutor());
        }
        catch (Exception e) {
            if (e instanceof TException) {
                this._serverMetrics.addMeteredGlobalValue((AbstractMetrics.Meter)ServerMeter.REQUEST_DESERIALIZATION_EXCEPTIONS, 1L);
            }
            String hexString = requestBytes != null ? BytesUtils.toHexString(requestBytes) : "";
            long reqestId = instanceRequest != null ? instanceRequest.getRequestId() : 0L;
            LOGGER.error("Exception while processing instance request: {}", (Object)hexString, (Object)e);
            this.sendErrorResponse(ctx, reqestId, tableNameWithType, queryArrivalTimeMs, DataTableBuilder.getEmptyDataTable(), e);
        }
    }

    private FutureCallback<byte[]> createCallback(final ChannelHandlerContext ctx, final String tableNameWithType, final long queryArrivalTimeMs, final InstanceRequest instanceRequest, final ServerQueryRequest queryRequest) {
        return new FutureCallback<byte[]>(){

            public void onSuccess(@Nullable byte[] responseBytes) {
                if (responseBytes != null) {
                    InstanceRequestHandler.this.sendResponse(ctx, queryRequest.getTableNameWithType(), queryArrivalTimeMs, responseBytes);
                } else {
                    InstanceRequestHandler.this.sendErrorResponse(ctx, queryRequest.getRequestId(), tableNameWithType, queryArrivalTimeMs, DataTableBuilder.getEmptyDataTable(), new Exception("Null query response."));
                }
            }

            public void onFailure(Throwable t) {
                LOGGER.error("Exception while processing instance request", t);
                InstanceRequestHandler.this.sendErrorResponse(ctx, instanceRequest.getRequestId(), tableNameWithType, queryArrivalTimeMs, DataTableBuilder.getEmptyDataTable(), new Exception(t));
            }
        };
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        String message = "Unhandled Exception in " + ((Object)((Object)this)).getClass().getCanonicalName();
        LOGGER.error(message, cause);
        this.sendErrorResponse(ctx, 0L, null, System.currentTimeMillis(), DataTableBuilder.getEmptyDataTable(), new Exception(message, cause));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendErrorResponse(ChannelHandlerContext ctx, long requestId, String tableNameWithType, long queryArrivalTimeMs, DataTable dataTable, Exception e) {
        try {
            Map dataTableMetadata = dataTable.getMetadata();
            dataTableMetadata.put(DataTable.MetadataKey.REQUEST_ID.getName(), Long.toString(requestId));
            dataTable.addException(QueryException.getException((ProcessingException)QueryException.QUERY_EXECUTION_ERROR, (Exception)e));
            byte[] serializedDataTable = dataTable.toBytes();
            this.sendResponse(ctx, tableNameWithType, queryArrivalTimeMs, serializedDataTable);
        }
        catch (Exception exception) {
            LOGGER.error("Exception while sending query processing error to Broker.", (Throwable)exception);
        }
        finally {
            LOGGER.error("Query processing error: ", (Throwable)e);
            this._serverMetrics.addMeteredGlobalValue((AbstractMetrics.Meter)ServerMeter.QUERY_EXECUTION_EXCEPTIONS, 1L);
        }
    }

    private void sendResponse(ChannelHandlerContext ctx, String tableNameWithType, long queryArrivalTimeMs, byte[] serializedDataTable) {
        long sendResponseStartTimeMs = System.currentTimeMillis();
        int queryProcessingTimeMs = (int)(sendResponseStartTimeMs - queryArrivalTimeMs);
        ctx.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])serializedDataTable)).addListener(f -> {
            long sendResponseEndTimeMs = System.currentTimeMillis();
            int sendResponseLatencyMs = (int)(sendResponseEndTimeMs - sendResponseStartTimeMs);
            this._serverMetrics.addMeteredGlobalValue((AbstractMetrics.Meter)ServerMeter.NETTY_CONNECTION_RESPONSES_SENT, 1L);
            this._serverMetrics.addMeteredGlobalValue((AbstractMetrics.Meter)ServerMeter.NETTY_CONNECTION_BYTES_SENT, (long)serializedDataTable.length);
            this._serverMetrics.addTimedTableValue(tableNameWithType, (AbstractMetrics.Timer)ServerTimer.NETTY_CONNECTION_SEND_RESPONSE_LATENCY, (long)sendResponseLatencyMs, TimeUnit.MILLISECONDS);
            int totalQueryTimeMs = (int)(sendResponseEndTimeMs - queryArrivalTimeMs);
            if (totalQueryTimeMs > 100) {
                LOGGER.info("Slow query: request handler processing time: {}, send response latency: {}, total time to handle request: {}", new Object[]{queryProcessingTimeMs, sendResponseLatencyMs, totalQueryTimeMs});
            }
        });
    }
}

