/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.transport.grpc;

import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.ServerMeter;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.common.proto.PinotQueryServerGrpc;
import org.apache.pinot.common.proto.Server;
import org.apache.pinot.common.utils.DataTable;
import org.apache.pinot.core.operator.streaming.StreamingResponseUtils;
import org.apache.pinot.core.query.executor.QueryExecutor;
import org.apache.pinot.core.query.request.ServerQueryRequest;
import org.apache.pinot.core.query.scheduler.resources.ResourceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcQueryServer
extends PinotQueryServerGrpc.PinotQueryServerImplBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(GrpcQueryServer.class);
    private final QueryExecutor _queryExecutor;
    private final ServerMetrics _serverMetrics;
    private final Server _server;
    private final ExecutorService _executorService = Executors.newFixedThreadPool(ResourceManager.DEFAULT_QUERY_WORKER_THREADS);

    public GrpcQueryServer(int port, QueryExecutor queryExecutor, ServerMetrics serverMetrics) {
        this._queryExecutor = queryExecutor;
        this._serverMetrics = serverMetrics;
        this._server = ServerBuilder.forPort((int)port).addService((BindableService)this).build();
        LOGGER.info("Initialized GrpcQueryServer on port: {} with numWorkerThreads: {}", (Object)port, (Object)ResourceManager.DEFAULT_QUERY_WORKER_THREADS);
    }

    public void start() {
        LOGGER.info("Starting GrpcQueryServer");
        try {
            this._server.start();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void shutdown() {
        LOGGER.info("Shutting down GrpcQueryServer");
        try {
            this._server.shutdown().awaitTermination();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void submit(Server.ServerRequest request, StreamObserver<Server.ServerResponse> responseObserver) {
        Server.ServerResponse response;
        DataTable dataTable;
        ServerQueryRequest queryRequest;
        try {
            queryRequest = new ServerQueryRequest(request, this._serverMetrics);
        }
        catch (Exception e) {
            LOGGER.error("Caught exception while deserializing the request: {}", (Object)request, (Object)e);
            this._serverMetrics.addMeteredGlobalValue((AbstractMetrics.Meter)ServerMeter.REQUEST_DESERIALIZATION_EXCEPTIONS, 1L);
            responseObserver.onError((Throwable)Status.INVALID_ARGUMENT.withDescription("Bad request").withCause((Throwable)e).asException());
            return;
        }
        try {
            dataTable = this._queryExecutor.processQuery(queryRequest, this._executorService, responseObserver);
        }
        catch (Exception e) {
            LOGGER.error("Caught exception while processing request {}: {} from broker: {}", new Object[]{queryRequest.getRequestId(), queryRequest.getQueryContext(), queryRequest.getBrokerId(), e});
            this._serverMetrics.addMeteredGlobalValue((AbstractMetrics.Meter)ServerMeter.UNCAUGHT_EXCEPTIONS, 1L);
            responseObserver.onError((Throwable)Status.INTERNAL.withCause((Throwable)e).asException());
            return;
        }
        try {
            response = queryRequest.isEnableStreaming() ? StreamingResponseUtils.getMetadataResponse(dataTable) : StreamingResponseUtils.getNonStreamingResponse(dataTable);
        }
        catch (Exception e) {
            LOGGER.error("Caught exception while constructing response from data table for request {}: {} from broker: {}", new Object[]{queryRequest.getRequestId(), queryRequest.getQueryContext(), queryRequest.getBrokerId(), e});
            this._serverMetrics.addMeteredGlobalValue((AbstractMetrics.Meter)ServerMeter.RESPONSE_SERIALIZATION_EXCEPTIONS, 1L);
            responseObserver.onError((Throwable)Status.INTERNAL.withCause((Throwable)e).asException());
            return;
        }
        responseObserver.onNext((Object)response);
        responseObserver.onCompleted();
    }
}

