/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.util;

import com.google.common.base.Preconditions;
import java.util.Map;
import javax.annotation.Nullable;

public class QueryOptions {
    private final Long _timeoutMs;
    private final boolean _groupByModeSQL;
    private final boolean _responseFormatSQL;
    private final boolean _preserveType;
    private final boolean _skipUpsert;
    private final boolean _enableSegmentTrim;
    private final int _minSegmentTrimSize;

    public QueryOptions(@Nullable Map<String, String> queryOptions) {
        if (queryOptions != null) {
            this._timeoutMs = QueryOptions.getTimeoutMs(queryOptions);
            this._groupByModeSQL = "sql".equalsIgnoreCase(queryOptions.get("groupByMode"));
            this._responseFormatSQL = "sql".equalsIgnoreCase(queryOptions.get("responseFormat"));
            this._preserveType = Boolean.parseBoolean(queryOptions.get("preserveType"));
            this._skipUpsert = Boolean.parseBoolean(queryOptions.get("skipUpsert"));
            this._enableSegmentTrim = QueryOptions.isEnableSegmentTrim(queryOptions);
            this._minSegmentTrimSize = QueryOptions.getMinSegmentTrimSize(queryOptions);
        } else {
            this._timeoutMs = null;
            this._groupByModeSQL = false;
            this._responseFormatSQL = false;
            this._preserveType = false;
            this._skipUpsert = false;
            this._enableSegmentTrim = false;
            this._minSegmentTrimSize = -1;
        }
    }

    @Nullable
    public Long getTimeoutMs() {
        return this._timeoutMs;
    }

    public boolean isGroupByModeSQL() {
        return this._groupByModeSQL;
    }

    public boolean isResponseFormatSQL() {
        return this._responseFormatSQL;
    }

    public boolean isPreserveType() {
        return this._preserveType;
    }

    public boolean isSkipUpsert() {
        return this._skipUpsert;
    }

    @Nullable
    public Boolean isEnableSegmentTrim() {
        return this._enableSegmentTrim;
    }

    @Nullable
    public Integer getMinSegmentTrimSize() {
        return this._minSegmentTrimSize;
    }

    @Nullable
    public static Long getTimeoutMs(Map<String, String> queryOptions) {
        String timeoutMsString = queryOptions.get("timeoutMs");
        if (timeoutMsString != null) {
            long timeoutMs = Long.parseLong(timeoutMsString);
            Preconditions.checkState((timeoutMs > 0L ? 1 : 0) != 0, (String)"Query timeout must be positive, got: %s", (long)timeoutMs);
            return timeoutMs;
        }
        return null;
    }

    public static boolean isEnableSegmentTrim(Map<String, String> queryOptions) {
        return Boolean.parseBoolean(queryOptions.get("enableSegmentTrim"));
    }

    public static int getMinSegmentTrimSize(Map<String, String> queryOptions) {
        String minSegmentTrimSize = queryOptions.get("minSegmentTrimSize");
        if (minSegmentTrimSize != null) {
            return Integer.parseInt(minSegmentTrimSize);
        }
        return -1;
    }
}

