/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.pinot.spi.utils.Pairs;

public class SortedRangeIntersection {
    public static List<Pairs.IntPair> intersectSortedRangeSets(List<List<Pairs.IntPair>> sortedRangeSetList) {
        if (sortedRangeSetList == null || sortedRangeSetList.size() == 0) {
            return Collections.emptyList();
        }
        if (sortedRangeSetList.size() == 1) {
            return sortedRangeSetList.get(0);
        }
        for (List<Pairs.IntPair> rangeSet : sortedRangeSetList) {
            if (rangeSet.size() != 0) continue;
            return Collections.emptyList();
        }
        int[] currentRangeSetIndex = new int[sortedRangeSetList.size()];
        Arrays.fill(currentRangeSetIndex, 0);
        int maxHead = -1;
        int maxHeadIndex = -1;
        boolean reachedEnd = false;
        ArrayList<Pairs.IntPair> result = new ArrayList<Pairs.IntPair>();
        block1: while (!reachedEnd) {
            Pairs.IntPair pair;
            int i;
            for (i = 0; i < sortedRangeSetList.size(); ++i) {
                int head = sortedRangeSetList.get(i).get(currentRangeSetIndex[i]).getLeft();
                if (head <= maxHead) continue;
                maxHead = head;
                maxHeadIndex = i;
            }
            for (i = 0; i < sortedRangeSetList.size(); ++i) {
                if (i == maxHeadIndex) continue;
                boolean found = false;
                while (!found && currentRangeSetIndex[i] < sortedRangeSetList.get(i).size()) {
                    Pairs.IntPair range = sortedRangeSetList.get(i).get(currentRangeSetIndex[i]);
                    if (maxHead >= range.getLeft() && maxHead <= range.getRight()) {
                        found = true;
                        break;
                    }
                    if (range.getLeft() > maxHead) {
                        maxHead = range.getLeft();
                        maxHeadIndex = i;
                        i = -1;
                        break;
                    }
                    currentRangeSetIndex[i] = currentRangeSetIndex[i] + 1;
                }
                if (i == -1 || found) continue;
                reachedEnd = true;
                break;
            }
            if (reachedEnd) break;
            Pairs.IntPair intPair = sortedRangeSetList.get(0).get(currentRangeSetIndex[0]);
            Pairs.IntPair intersection = Pairs.intPair((int)intPair.getLeft(), (int)intPair.getRight());
            for (int i2 = 1; i2 < sortedRangeSetList.size(); ++i2) {
                pair = sortedRangeSetList.get(i2).get(currentRangeSetIndex[i2]);
                int start = Math.max(intersection.getLeft(), pair.getLeft());
                int end = Math.min(intersection.getRight(), pair.getRight());
                intersection.setLeft(start);
                intersection.setRight(end);
            }
            if (result.size() > 0) {
                Pairs.IntPair prevIntersection = (Pairs.IntPair)result.get(result.size() - 1);
                if (intersection.getLeft() == prevIntersection.getRight() + 1) {
                    prevIntersection.setRight(intersection.getRight());
                } else {
                    result.add(intersection);
                }
            } else {
                result.add(intersection);
            }
            for (int i3 = 0; i3 < sortedRangeSetList.size(); ++i3) {
                pair = sortedRangeSetList.get(i3).get(currentRangeSetIndex[i3]);
                if (pair.getRight() != intersection.getRight()) continue;
                currentRangeSetIndex[i3] = currentRangeSetIndex[i3] + 1;
                if (currentRangeSetIndex[i3] != sortedRangeSetList.get(i3).size()) continue;
                reachedEnd = true;
                continue block1;
            }
        }
        return result;
    }
}

