/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.intervals;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.intervals.DisiPriorityQueue;
import org.apache.lucene.queries.intervals.DisiWrapper;
import org.apache.lucene.queries.intervals.DisjunctionDISIApproximation;
import org.apache.lucene.queries.intervals.IntervalIterator;
import org.apache.lucene.queries.intervals.IntervalQuery;
import org.apache.lucene.queries.intervals.IntervalsSource;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.MatchesIterator;
import org.apache.lucene.search.MatchesUtils;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.util.PriorityQueue;

class DisjunctionIntervalsSource
extends IntervalsSource {
    final Collection<IntervalsSource> subSources;
    final boolean pullUpDisjunctions;
    private static final IntervalIterator EMPTY = new IntervalIterator(){

        public int docID() {
            throw new UnsupportedOperationException();
        }

        public int nextDoc() throws IOException {
            throw new UnsupportedOperationException();
        }

        public int advance(int target) throws IOException {
            throw new UnsupportedOperationException();
        }

        public long cost() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int start() {
            return -1;
        }

        @Override
        public int end() {
            return -1;
        }

        @Override
        public int gaps() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int nextInterval() {
            return Integer.MAX_VALUE;
        }

        @Override
        public float matchCost() {
            return 0.0f;
        }
    };
    private static final IntervalIterator EXHAUSTED = new IntervalIterator(){

        public int docID() {
            throw new UnsupportedOperationException();
        }

        public int nextDoc() throws IOException {
            throw new UnsupportedOperationException();
        }

        public int advance(int target) throws IOException {
            throw new UnsupportedOperationException();
        }

        public long cost() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int start() {
            return Integer.MAX_VALUE;
        }

        @Override
        public int end() {
            return Integer.MAX_VALUE;
        }

        @Override
        public int gaps() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int nextInterval() {
            return Integer.MAX_VALUE;
        }

        @Override
        public float matchCost() {
            return 0.0f;
        }
    };

    static IntervalsSource create(Collection<IntervalsSource> subSources, boolean pullUpDisjunctions) {
        if ((subSources = DisjunctionIntervalsSource.simplify(subSources)).size() == 1) {
            return subSources.iterator().next();
        }
        return new DisjunctionIntervalsSource(subSources, pullUpDisjunctions);
    }

    private DisjunctionIntervalsSource(Collection<IntervalsSource> subSources, boolean pullUpDisjunctions) {
        this.subSources = DisjunctionIntervalsSource.simplify(subSources);
        this.pullUpDisjunctions = pullUpDisjunctions;
    }

    private static Collection<IntervalsSource> simplify(Collection<IntervalsSource> sources) {
        HashSet<IntervalsSource> simplified = new HashSet<IntervalsSource>();
        for (IntervalsSource source : sources) {
            if (source instanceof DisjunctionIntervalsSource) {
                simplified.addAll(source.pullUpDisjunctions());
                continue;
            }
            simplified.add(source);
        }
        return simplified;
    }

    @Override
    public IntervalIterator intervals(String field, LeafReaderContext ctx) throws IOException {
        ArrayList<IntervalIterator> subIterators = new ArrayList<IntervalIterator>();
        for (IntervalsSource subSource : this.subSources) {
            IntervalIterator it = subSource.intervals(field, ctx);
            if (it == null) continue;
            subIterators.add(it);
        }
        if (subIterators.size() == 0) {
            return null;
        }
        return new DisjunctionIntervalIterator(subIterators);
    }

    @Override
    public MatchesIterator matches(String field, LeafReaderContext ctx, int doc) throws IOException {
        ArrayList<MatchesIterator> subMatches = new ArrayList<MatchesIterator>();
        for (IntervalsSource subSource : this.subSources) {
            MatchesIterator mi = subSource.matches(field, ctx, doc);
            if (mi == null) continue;
            subMatches.add(mi);
        }
        return MatchesUtils.disjunction(subMatches);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DisjunctionIntervalsSource that = (DisjunctionIntervalsSource)o;
        return Objects.equals(this.subSources, that.subSources);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.subSources);
    }

    @Override
    public String toString() {
        return this.subSources.stream().map(Object::toString).collect(Collectors.joining(",", "or(", ")"));
    }

    @Override
    public void visit(String field, QueryVisitor visitor) {
        IntervalQuery parent = new IntervalQuery(field, this);
        QueryVisitor v = visitor.getSubVisitor(BooleanClause.Occur.SHOULD, (Query)parent);
        for (IntervalsSource source : this.subSources) {
            source.visit(field, v);
        }
    }

    @Override
    public int minExtent() {
        int minExtent = Integer.MAX_VALUE;
        for (IntervalsSource subSource : this.subSources) {
            minExtent = Math.min(minExtent, subSource.minExtent());
        }
        return minExtent;
    }

    @Override
    public Collection<IntervalsSource> pullUpDisjunctions() {
        if (this.pullUpDisjunctions) {
            return this.subSources;
        }
        return Collections.singletonList(this);
    }

    static class DisjunctionIntervalIterator
    extends IntervalIterator {
        final DocIdSetIterator approximation;
        final PriorityQueue<IntervalIterator> intervalQueue;
        final DisiPriorityQueue disiQueue;
        final List<IntervalIterator> iterators;
        final float matchCost;
        IntervalIterator current = DisjunctionIntervalsSource.access$000();

        DisjunctionIntervalIterator(List<IntervalIterator> iterators) {
            this.disiQueue = new DisiPriorityQueue(iterators.size());
            for (IntervalIterator it : iterators) {
                this.disiQueue.add(new DisiWrapper(it));
            }
            this.approximation = new DisjunctionDISIApproximation(this.disiQueue);
            this.iterators = iterators;
            this.intervalQueue = new PriorityQueue<IntervalIterator>(iterators.size()){

                protected boolean lessThan(IntervalIterator a, IntervalIterator b) {
                    return a.end() < b.end() || a.end() == b.end() && a.start() >= b.start();
                }
            };
            float costsum = 0.0f;
            for (IntervalIterator it : iterators) {
                costsum += (float)it.cost();
            }
            this.matchCost = costsum;
        }

        @Override
        public float matchCost() {
            return this.matchCost;
        }

        @Override
        public int start() {
            return this.current.start();
        }

        @Override
        public int end() {
            return this.current.end();
        }

        @Override
        public int gaps() {
            return this.current.gaps();
        }

        private void reset() throws IOException {
            this.intervalQueue.clear();
            DisiWrapper dw = this.disiQueue.topList();
            while (dw != null) {
                dw.intervals.nextInterval();
                this.intervalQueue.add((Object)dw.intervals);
                dw = dw.next;
            }
            this.current = EMPTY;
        }

        @Override
        public int nextInterval() throws IOException {
            if (this.current == EMPTY || this.current == EXHAUSTED) {
                if (this.intervalQueue.size() > 0) {
                    this.current = (IntervalIterator)((Object)this.intervalQueue.top());
                }
                return this.current.start();
            }
            int start = this.current.start();
            int end = this.current.end();
            while (this.intervalQueue.size() > 0 && this.contains((IntervalIterator)((Object)this.intervalQueue.top()), start, end)) {
                IntervalIterator it = (IntervalIterator)((Object)this.intervalQueue.pop());
                if (it == null || it.nextInterval() == Integer.MAX_VALUE) continue;
                this.intervalQueue.add((Object)it);
            }
            if (this.intervalQueue.size() == 0) {
                this.current = EXHAUSTED;
                return Integer.MAX_VALUE;
            }
            this.current = (IntervalIterator)((Object)this.intervalQueue.top());
            return this.current.start();
        }

        private boolean contains(IntervalIterator it, int start, int end) {
            return start >= it.start() && start <= it.end() && end >= it.start() && end <= it.end();
        }

        public int docID() {
            return this.approximation.docID();
        }

        public int nextDoc() throws IOException {
            int doc = this.approximation.nextDoc();
            this.reset();
            return doc;
        }

        public int advance(int target) throws IOException {
            int doc = this.approximation.advance(target);
            this.reset();
            return doc;
        }

        public long cost() {
            return this.approximation.cost();
        }
    }
}

