/*
 * Decompiled with CFR 0.152.
 */
package com.qubole.rubix.bookkeeper;

import com.google.shaded.shaded.common.base.Preconditions;
import com.qubole.rubix.bookkeeper.BookKeeper;
import com.qubole.rubix.core.ReadRequest;
import com.qubole.rubix.core.ReadRequestChain;
import com.qubole.rubix.core.ReadRequestChainStats;
import com.qubole.rubix.core.RemoteReadRequestChain;
import com.qubole.rubix.spi.CacheConfig;
import com.qubole.rubix.spi.CommonUtilities;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class FileDownloadRequestChain
extends ReadRequestChain {
    private BookKeeper bookKeeper;
    private FileSystem remoteFileSystem;
    private String localFile;
    private String remotePath;
    private long fileSize;
    private long lastModified;
    private long totalRequestedRead;
    private final int maxRemoteReadBufferSize;
    Configuration conf;
    ByteBuffer directBuffer;
    private long timeSpentOnDownload;
    private int blockSize;
    private static final Log log = LogFactory.getLog(FileDownloadRequestChain.class);

    public FileDownloadRequestChain(BookKeeper bookKeeper, FileSystem remoteFileSystem, String localfile, ByteBuffer directBuffer, Configuration conf, String remotePath, long fileSize, long lastModified, int generationNumber) {
        super(generationNumber, FileDownloadRequestChain.getBlockAlignedMaxChunkSize(conf));
        this.bookKeeper = bookKeeper;
        this.remoteFileSystem = remoteFileSystem;
        this.localFile = localfile;
        this.conf = conf;
        this.remotePath = remotePath;
        this.fileSize = fileSize;
        this.lastModified = lastModified;
        this.directBuffer = directBuffer;
        this.maxRemoteReadBufferSize = CacheConfig.getDataTransferBufferSize(conf);
        this.blockSize = CacheConfig.getBlockSize(conf);
    }

    private static long getBlockAlignedMaxChunkSize(Configuration conf) {
        long maxReadRequestLength = CacheConfig.getParallelWarmupMaxChunkSize(conf);
        long blockSize = CacheConfig.getBlockSize(conf);
        return maxReadRequestLength / blockSize * blockSize;
    }

    public String getRemotePath() {
        return this.remotePath;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public long getTimeSpentOnDownload() {
        return this.timeSpentOnDownload;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long call() throws IOException {
        Preconditions.checkState(this.isLocked(), "Trying to execute Chain without locking");
        List<ReadRequest> readRequests = this.getReadRequests();
        if (readRequests.size() == 0) {
            return 0L;
        }
        long startTime = System.currentTimeMillis();
        File file = new File(this.localFile);
        if (!file.exists()) {
            throw new FileNotFoundException(String.format("File does not exists %s", this.localFile));
        }
        long highestReadRequestLength = readRequests.stream().map(readRequest -> readRequest.getActualReadLength()).max(Long::compareTo).get();
        int remoteReadBufferSize = Math.min(this.maxRemoteReadBufferSize, Math.toIntExact(Math.min(Integer.MAX_VALUE, highestReadRequestLength)));
        byte[] remoteReadBuffer = new byte[remoteReadBufferSize];
        FSDataInputStream inputStream = null;
        AbstractInterruptibleChannel fileChannel = null;
        FileSystem fileSystem = this.remoteFileSystem;
        try {
            inputStream = fileSystem.open(new Path(this.remotePath));
            fileChannel = new FileOutputStream(new RandomAccessFile(file, "rw").getFD()).getChannel();
            for (ReadRequest readRequest2 : readRequests) {
                if (this.isCancelled()) {
                    log.debug((Object)("Request Cancelled for " + readRequest2.getBackendReadStart()));
                    this.propagateCancel(this.getClass().getName());
                }
                long readBytes = this.copyIntoCache(inputStream, (FileChannel)fileChannel, readRequest2.getBackendReadStart(), readRequest2.getBackendReadLength(), remoteReadBuffer);
                this.totalRequestedRead += readBytes;
                this.updateCacheStatus(readRequest2);
            }
            long endTime = System.currentTimeMillis();
            this.timeSpentOnDownload = (endTime - startTime) / 1000L;
            log.debug((Object)("Downloaded " + this.totalRequestedRead + " bytes of file " + this.remotePath));
            log.debug((Object)("RemoteFetchRequest took : " + this.timeSpentOnDownload + " secs "));
            Long l = this.totalRequestedRead;
            return l;
        }
        finally {
            if (fileChannel != null) {
                fileChannel.close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    private long copyIntoCache(FSDataInputStream inputStream, FileChannel fileChannel, long cacheReadStart, long length, byte[] remoteReadBuffer) throws IOException {
        log.debug((Object)String.format("Copying data of file %s of length %d from position %d", this.remotePath, length, cacheReadStart));
        if (length <= (long)remoteReadBuffer.length) {
            inputStream.readFully(cacheReadStart, remoteReadBuffer, 0, Math.toIntExact(length));
            this.writeToFile(remoteReadBuffer, Math.toIntExact(length), fileChannel, cacheReadStart);
        } else {
            int toRead;
            for (long leftToRead = length; leftToRead > 0L; leftToRead -= (long)toRead) {
                toRead = Math.toIntExact(Math.min((long)remoteReadBuffer.length, leftToRead));
                inputStream.seek(cacheReadStart);
                RemoteReadRequestChain.readIntoBuffer(remoteReadBuffer, 0, toRead, inputStream);
                this.writeToFile(remoteReadBuffer, toRead, fileChannel, cacheReadStart);
                cacheReadStart += (long)toRead;
            }
        }
        log.debug((Object)String.format("Copied %d to file %s from position %d", length, this.remotePath, cacheReadStart));
        return length;
    }

    private void writeToFile(byte[] buffer, int length, FileChannel fileChannel, long cacheReadStart) throws IOException {
        int nwrite;
        int writtenSoFar = 0;
        for (int leftToWrite = length; leftToWrite > 0; leftToWrite -= nwrite) {
            int writeInThisCycle = Math.min(leftToWrite, this.directBuffer.capacity());
            this.directBuffer.clear();
            this.directBuffer.put(buffer, writtenSoFar, writeInThisCycle);
            this.directBuffer.flip();
            nwrite = fileChannel.write(this.directBuffer, cacheReadStart + (long)writtenSoFar);
            this.directBuffer.compact();
            writtenSoFar += nwrite;
        }
    }

    private void updateCacheStatus(ReadRequest readRequest) {
        long startBlock = CommonUtilities.toStartBlock(readRequest.getBackendReadStart(), this.blockSize);
        long endBlock = CommonUtilities.toEndBlock(readRequest.getBackendReadEnd(), this.blockSize);
        try {
            this.bookKeeper.setAllCached(this.remotePath, this.fileSize, this.lastModified, startBlock, endBlock, this.generationNumber);
        }
        catch (Exception e) {
            log.warn((Object)String.format("Unable to update cache status for %s:%d:%d, this can cause wrong accounting of disk utilization", this.remotePath, startBlock, endBlock), (Throwable)e);
        }
    }

    @Override
    public ReadRequestChainStats getStats() {
        return new ReadRequestChainStats().setRemoteRRCDataRead(this.totalRequestedRead).setRemoteRRCWarmupTime(this.timeSpentOnDownload);
    }
}

