/*
 * Decompiled with CFR 0.152.
 */
package com.qubole.rubix.bookkeeper.validation;

import java.util.HashSet;
import java.util.Set;

public class FileValidatorResult {
    private int successes;
    private int totalFiles;
    private double successRate;
    private Set<String> filesWithoutMD = new HashSet<String>();

    public FileValidatorResult() {
    }

    public FileValidatorResult(int successes, int totalFiles, Set<String> filesWithoutMD) {
        this.successes = successes;
        this.totalFiles = totalFiles;
        this.filesWithoutMD = filesWithoutMD;
        this.successRate = totalFiles > 0 ? (double)successes / (double)totalFiles : 0.0;
    }

    public int getSuccessCount() {
        return this.successes;
    }

    public int getFailureCount() {
        return this.totalFiles - this.successes;
    }

    public int getTotalFiles() {
        return this.totalFiles;
    }

    public double getSuccessRate() {
        return this.successRate;
    }

    public Set<String> getFilesWithoutMD() {
        return this.filesWithoutMD;
    }

    public void addResult(FileValidatorResult result) {
        this.successes += result.successes;
        this.totalFiles += result.totalFiles;
        this.filesWithoutMD.addAll(result.filesWithoutMD);
        this.successRate = (double)this.successes / (double)this.totalFiles;
    }
}

