/*
 * Decompiled with CFR 0.152.
 */
package com.qubole.rubix.core;

import com.google.shaded.shaded.common.annotations.VisibleForTesting;
import com.google.shaded.shaded.common.base.Preconditions;
import com.qubole.rubix.core.ReadRequest;
import com.qubole.rubix.core.ReadRequestChainStats;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;

public abstract class ReadRequestChain
implements Callable<Long> {
    List<ReadRequest> readRequests = new ArrayList<ReadRequest>();
    ReadRequest lastRequest;
    boolean isLocked;
    boolean cancelled;
    private long maxReadRequestSize;
    protected final int generationNumber;
    protected String threadName;
    protected long requests;
    private static final Log log = LogFactory.getLog(ReadRequestChain.class);

    public ReadRequestChain(int generationNumber) {
        this(generationNumber, Long.MAX_VALUE);
    }

    public ReadRequestChain(int generationNumber, long maxReadRequestSize) {
        this.generationNumber = generationNumber;
        this.maxReadRequestSize = maxReadRequestSize;
        this.threadName = Thread.currentThread().getName();
    }

    @VisibleForTesting
    public void setMaxReadRequestSize(long maxReadRequestSize) {
        this.maxReadRequestSize = maxReadRequestSize;
    }

    public void addReadRequest(ReadRequest readRequest) {
        Preconditions.checkState(!this.isLocked, "Adding request to a locked chain");
        if (this.lastRequest == null) {
            this.lastRequest = readRequest;
        } else if (this.lastRequest.getBackendReadEnd() == readRequest.getBackendReadStart()) {
            this.lastRequest.setBackendReadEnd(readRequest.getBackendReadEnd());
            this.lastRequest.setActualReadEnd(readRequest.getActualReadEnd());
        } else {
            this.addRequest(this.lastRequest);
            this.lastRequest = readRequest;
        }
        ++this.requests;
    }

    private void addRequest(ReadRequest readRequest) {
        long backendReadLength = readRequest.getBackendReadLength();
        if (backendReadLength <= this.maxReadRequestSize) {
            this.addRequestToQueue(readRequest);
            return;
        }
        long backendReadStart = 0L;
        long actualReadStart = readRequest.getActualReadStart();
        while (backendReadStart < backendReadLength) {
            long backendReadEnd = backendReadStart + Math.min(this.maxReadRequestSize, backendReadLength - backendReadStart);
            ReadRequest chunkedRequest = new ReadRequest(backendReadStart, backendReadEnd, actualReadStart, Math.min(readRequest.getActualReadEnd(), backendReadEnd), readRequest.getDestBuffer(), readRequest.getDestBufferOffset() + Math.toIntExact(actualReadStart - readRequest.getActualReadStart()), readRequest.getBackendFileSize());
            this.addRequestToQueue(chunkedRequest);
            actualReadStart = backendReadStart = backendReadEnd;
        }
    }

    private void addRequestToQueue(ReadRequest readRequest) {
        this.readRequests.add(readRequest);
        log.debug((Object)String.format("Added ReadRequest: [%d, %d, %d, %d, %d]", readRequest.getBackendReadStart(), readRequest.getBackendReadEnd(), readRequest.getActualReadStart(), readRequest.getActualReadEnd(), readRequest.getDestBufferOffset()));
    }

    public void lock() {
        this.isLocked = true;
        if (this.lastRequest != null) {
            this.addRequest(this.lastRequest);
            this.lastRequest = null;
        }
    }

    public List<ReadRequest> getReadRequests() {
        return this.readRequests;
    }

    public abstract ReadRequestChainStats getStats();

    public void updateCacheStatus(String remotePath, long fileSize, long lastModified, int blockSize, Configuration conf) {
    }

    public void cancel() {
        this.cancelled = true;
    }

    protected void propagateCancel(String className) throws IOException {
        throw new CancelledException(className + " Cancelled");
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    protected class InvalidationRequiredException
    extends IOException {
        public InvalidationRequiredException(String message) {
            super(message);
        }
    }

    protected class CancelledException
    extends IOException {
        public CancelledException(String message) {
            super(message);
        }
    }
}

