/*
 * Decompiled with CFR 0.152.
 */
package com.qubole.rubix.spi;

import com.google.shaded.shaded.common.annotations.VisibleForTesting;
import com.qubole.rubix.spi.CacheConfig;
import com.qubole.rubix.spi.LocalBookKeeperClient;
import com.qubole.rubix.spi.RetryingPooledBookkeeperClient;
import com.qubole.rubix.spi.fop.ObjectPool;
import com.qubole.rubix.spi.fop.Poolable;
import com.qubole.rubix.spi.fop.SocketObjectFactory;
import com.qubole.rubix.spi.thrift.BookKeeperService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.thrift.shaded.transport.TTransport;
import org.apache.thrift.shaded.transport.TTransportException;

public class BookKeeperFactory {
    BookKeeperService.Iface bookKeeper;
    private static Log log = LogFactory.getLog((String)BookKeeperFactory.class.getName());
    private static final AtomicBoolean initFlag = new AtomicBoolean();
    static ObjectPool pool;
    private static final String LOCALHOST = "localhost";

    public BookKeeperFactory() {
    }

    @VisibleForTesting
    public static void resetConnectionPool() {
        initFlag.set(false);
        pool = null;
    }

    public BookKeeperFactory(BookKeeperService.Iface bookKeeper) {
        if (bookKeeper != null) {
            this.bookKeeper = bookKeeper;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RetryingPooledBookkeeperClient createBookKeeperClient(String host, Configuration conf) throws TTransportException {
        if (!initFlag.get()) {
            AtomicBoolean atomicBoolean = initFlag;
            synchronized (atomicBoolean) {
                if (!initFlag.get()) {
                    pool = SocketObjectFactory.createSocketObjectPool(conf, host, CacheConfig.getBookKeeperServerPort(conf));
                    initFlag.set(true);
                }
            }
        }
        if (this.bookKeeper != null) {
            return new LocalBookKeeperClient(this.bookKeeper);
        }
        Poolable<TTransport> obj = pool.borrowObject(host, conf);
        RetryingPooledBookkeeperClient retryingBookkeeperClient = new RetryingPooledBookkeeperClient(obj, host, conf);
        return retryingBookkeeperClient;
    }

    public RetryingPooledBookkeeperClient createBookKeeperClient(String host, Configuration conf, int maxRetries, long retryInterval, boolean throwException) {
        for (int failedStarts = 1; failedStarts <= maxRetries; ++failedStarts) {
            try {
                return this.createBookKeeperClient(host, conf);
            }
            catch (Exception e) {
                log.warn((Object)String.format("Could not create bookkeeper client [%d/%d attempts]", failedStarts, maxRetries));
                try {
                    Thread.sleep(retryInterval);
                }
                catch (InterruptedException e2) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
        }
        log.fatal((Object)"Ran out of retries to create bookkeeper client.");
        if (throwException) {
            throw new RuntimeException("Could not create bookkeeper client");
        }
        return null;
    }

    public boolean isBookKeeperInitialized() {
        return this.bookKeeper != null;
    }

    public RetryingPooledBookkeeperClient createBookKeeperClient(Configuration conf) throws TTransportException {
        return this.createBookKeeperClient(LOCALHOST, conf);
    }
}

