/*
 * Decompiled with CFR 0.152.
 */
package jnr.posix;

import jnr.ffi.Runtime;
import jnr.ffi.StructLayout;
import jnr.posix.BaseFileStat;
import jnr.posix.LinuxPOSIX;

public final class LinuxFileStat64
extends BaseFileStat {
    private static final Layout layout = new Layout(Runtime.getSystemRuntime());

    public LinuxFileStat64(LinuxPOSIX posix) {
        super(posix, layout);
    }

    @Override
    public long atime() {
        return LinuxFileStat64.layout.st_atime.get(this.memory);
    }

    public long aTimeNanoSecs() {
        return LinuxFileStat64.layout.st_atimensec.get(this.memory);
    }

    @Override
    public long blockSize() {
        return LinuxFileStat64.layout.st_blksize.get(this.memory);
    }

    @Override
    public long blocks() {
        return LinuxFileStat64.layout.st_blocks.get(this.memory);
    }

    @Override
    public long ctime() {
        return LinuxFileStat64.layout.st_ctime.get(this.memory);
    }

    public long cTimeNanoSecs() {
        return LinuxFileStat64.layout.st_ctimensec.get(this.memory);
    }

    @Override
    public long dev() {
        return LinuxFileStat64.layout.st_dev.get(this.memory);
    }

    @Override
    public int gid() {
        return LinuxFileStat64.layout.st_gid.get(this.memory);
    }

    @Override
    public long ino() {
        return LinuxFileStat64.layout.st_ino.get(this.memory);
    }

    @Override
    public int mode() {
        return LinuxFileStat64.layout.st_mode.get(this.memory);
    }

    @Override
    public long mtime() {
        return LinuxFileStat64.layout.st_mtime.get(this.memory);
    }

    public long mTimeNanoSecs() {
        return LinuxFileStat64.layout.st_mtimensec.get(this.memory);
    }

    @Override
    public int nlink() {
        return (int)LinuxFileStat64.layout.st_nlink.get(this.memory);
    }

    @Override
    public long rdev() {
        return LinuxFileStat64.layout.st_rdev.get(this.memory);
    }

    @Override
    public long st_size() {
        return LinuxFileStat64.layout.st_size.get(this.memory);
    }

    @Override
    public int uid() {
        return LinuxFileStat64.layout.st_uid.get(this.memory);
    }

    public static final class Layout
    extends StructLayout {
        public final StructLayout.Signed64 st_dev = new StructLayout.Signed64();
        public final StructLayout.Signed64 st_ino = new StructLayout.Signed64();
        public final StructLayout.Signed64 st_nlink = new StructLayout.Signed64();
        public final StructLayout.Signed32 st_mode = new StructLayout.Signed32();
        public final StructLayout.Signed32 st_uid = new StructLayout.Signed32();
        public final StructLayout.Signed32 st_gid = new StructLayout.Signed32();
        public final StructLayout.Signed64 st_rdev = new StructLayout.Signed64();
        public final StructLayout.Signed64 st_size = new StructLayout.Signed64();
        public final StructLayout.Signed64 st_blksize = new StructLayout.Signed64();
        public final StructLayout.Signed64 st_blocks = new StructLayout.Signed64();
        public final StructLayout.Signed64 st_atime = new StructLayout.Signed64();
        public final StructLayout.Signed64 st_atimensec = new StructLayout.Signed64();
        public final StructLayout.Signed64 st_mtime = new StructLayout.Signed64();
        public final StructLayout.Signed64 st_mtimensec = new StructLayout.Signed64();
        public final StructLayout.Signed64 st_ctime = new StructLayout.Signed64();
        public final StructLayout.Signed64 st_ctimensec = new StructLayout.Signed64();
        public final StructLayout.Signed64 __unused4 = new StructLayout.Signed64();
        public final StructLayout.Signed64 __unused5 = new StructLayout.Signed64();
        public final StructLayout.Signed64 __unused6 = new StructLayout.Signed64();

        public Layout(Runtime runtime) {
            super(runtime);
        }
    }
}

