/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockUtil;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import org.openjdk.jol.info.ClassLayout;

public class Int96ArrayBlock
implements Block {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(Int96ArrayBlock.class).instanceSize();
    public static final int INT96_BYTES = 12;
    public static final int SIZE_IN_BYTES_PER_POSITION = 13;
    private final int positionOffset;
    private final int positionCount;
    @Nullable
    private final boolean[] valueIsNull;
    private final long[] high;
    private final int[] low;
    private final long sizeInBytes;
    private final long retainedSizeInBytes;

    public Int96ArrayBlock(int positionCount, Optional<boolean[]> valueIsNull, long[] high, int[] low) {
        this(0, positionCount, valueIsNull.orElse(null), high, low);
    }

    Int96ArrayBlock(int positionOffset, int positionCount, boolean[] valueIsNull, long[] high, int[] low) {
        if (positionOffset < 0) {
            throw new IllegalArgumentException("positionOffset is negative");
        }
        this.positionOffset = positionOffset;
        if (positionCount < 0) {
            throw new IllegalArgumentException("positionCount is negative");
        }
        this.positionCount = positionCount;
        if (high.length - positionOffset < positionCount) {
            throw new IllegalArgumentException("high length is less than positionCount");
        }
        this.high = high;
        if (low.length - positionOffset < positionCount) {
            throw new IllegalArgumentException("low length is less than positionCount");
        }
        this.low = low;
        if (valueIsNull != null && valueIsNull.length - positionOffset < positionCount) {
            throw new IllegalArgumentException("isNull length is less than positionCount");
        }
        this.valueIsNull = valueIsNull;
        this.sizeInBytes = 13L * (long)positionCount;
        this.retainedSizeInBytes = (long)INSTANCE_SIZE + SizeOf.sizeOf((boolean[])valueIsNull) + SizeOf.sizeOf((long[])high) + SizeOf.sizeOf((int[])low);
    }

    @Override
    public OptionalInt fixedSizeInBytesPerPosition() {
        return OptionalInt.of(13);
    }

    @Override
    public long getSizeInBytes() {
        return this.sizeInBytes;
    }

    @Override
    public long getRegionSizeInBytes(int position, int length) {
        return 13L * (long)length;
    }

    @Override
    public long getPositionsSizeInBytes(boolean[] positions, int selectedPositionsCount) {
        return 13L * (long)selectedPositionsCount;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return this.retainedSizeInBytes;
    }

    @Override
    public long getEstimatedDataSizeForStats(int position) {
        return this.isNull(position) ? 0L : 12L;
    }

    @Override
    public void retainedBytesForEachPart(BiConsumer<Object, Long> consumer) {
        consumer.accept(this.high, SizeOf.sizeOf((long[])this.high));
        consumer.accept(this.low, SizeOf.sizeOf((int[])this.low));
        if (this.valueIsNull != null) {
            consumer.accept(this.valueIsNull, SizeOf.sizeOf((boolean[])this.valueIsNull));
        }
        consumer.accept(this, Long.valueOf(INSTANCE_SIZE));
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public long getLong(int position, int offset) {
        this.checkReadablePosition(position);
        if (offset != 0) {
            throw new IllegalArgumentException("offset must be 0");
        }
        return this.high[this.positionOffset + position];
    }

    @Override
    public int getInt(int position, int offset) {
        this.checkReadablePosition(position);
        if (offset != 8) {
            throw new IllegalArgumentException("offset must be 8");
        }
        return this.low[this.positionOffset + position];
    }

    @Override
    public boolean mayHaveNull() {
        return this.valueIsNull != null;
    }

    @Override
    public boolean isNull(int position) {
        this.checkReadablePosition(position);
        return this.valueIsNull != null && this.valueIsNull[position + this.positionOffset];
    }

    @Override
    public Block getSingleValueBlock(int position) {
        boolean[] blArray;
        this.checkReadablePosition(position);
        if (this.isNull(position)) {
            boolean[] blArray2 = new boolean[1];
            blArray = blArray2;
            blArray2[0] = true;
        } else {
            blArray = null;
        }
        return new Int96ArrayBlock(0, 1, blArray, new long[]{this.high[position + this.positionOffset]}, new int[]{this.low[position + this.positionOffset]});
    }

    @Override
    public Block copyPositions(int[] positions, int offset, int length) {
        BlockUtil.checkArrayRange(positions, offset, length);
        boolean[] newValueIsNull = null;
        if (this.valueIsNull != null) {
            newValueIsNull = new boolean[length];
        }
        long[] newHigh = new long[length];
        int[] newLow = new int[length];
        for (int i = 0; i < length; ++i) {
            int position = positions[offset + i];
            this.checkReadablePosition(position);
            if (this.valueIsNull != null) {
                newValueIsNull[i] = this.valueIsNull[position + this.positionOffset];
            }
            newHigh[i] = this.high[position + this.positionOffset];
            newLow[i] = this.low[position + this.positionOffset];
        }
        return new Int96ArrayBlock(0, length, newValueIsNull, newHigh, newLow);
    }

    @Override
    public Block getRegion(int positionOffset, int length) {
        BlockUtil.checkValidRegion(this.getPositionCount(), positionOffset, length);
        return new Int96ArrayBlock(positionOffset + this.positionOffset, length, this.valueIsNull, this.high, this.low);
    }

    @Override
    public Block copyRegion(int positionOffset, int length) {
        BlockUtil.checkValidRegion(this.getPositionCount(), positionOffset, length);
        boolean[] newValueIsNull = this.valueIsNull == null ? null : BlockUtil.compactArray(this.valueIsNull, positionOffset += this.positionOffset, length);
        long[] newHigh = BlockUtil.compactArray(this.high, positionOffset, length);
        int[] newLow = BlockUtil.compactArray(this.low, positionOffset, length);
        if (newValueIsNull == this.valueIsNull && newHigh == this.high && newLow == this.low) {
            return this;
        }
        return new Int96ArrayBlock(0, length, newValueIsNull, newHigh, newLow);
    }

    @Override
    public String getEncodingName() {
        return "INT96_ARRAY";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Int96ArrayBlock{");
        sb.append("positionCount=").append(this.getPositionCount());
        sb.append('}');
        return sb.toString();
    }

    Slice getHighSlice() {
        return Slices.wrappedLongArray((long[])this.high, (int)this.positionOffset, (int)this.positionCount);
    }

    Slice getLowSlice() {
        return Slices.wrappedIntArray((int[])this.low, (int)this.positionOffset, (int)this.positionCount);
    }

    private void checkReadablePosition(int position) {
        if (position < 0 || position >= this.getPositionCount()) {
            throw new IllegalArgumentException("position is not valid");
        }
    }
}

