/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.airlift.slice.Slice;
import io.trino.spi.block.AbstractSingleRowBlock;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.BlockBuilderStatus;
import java.util.OptionalInt;
import java.util.function.BiConsumer;
import org.openjdk.jol.info.ClassLayout;

public class SingleRowBlockWriter
extends AbstractSingleRowBlock
implements BlockBuilder {
    public static final int INSTANCE_SIZE = ClassLayout.parseClass(SingleRowBlockWriter.class).instanceSize();
    private final BlockBuilder[] fieldBlockBuilders;
    private int currentFieldIndexToWrite;
    private int rowIndex = -1;
    private boolean fieldBlockBuilderReturned;

    SingleRowBlockWriter(BlockBuilder[] fieldBlockBuilders) {
        this.fieldBlockBuilders = fieldBlockBuilders;
    }

    public BlockBuilder getFieldBlockBuilder(int fieldIndex) {
        if (this.currentFieldIndexToWrite != 0) {
            throw new IllegalStateException("field block builder can only be obtained before any sequential write has done");
        }
        this.fieldBlockBuilderReturned = true;
        return this.fieldBlockBuilders[fieldIndex];
    }

    @Override
    Block[] getRawFieldBlocks() {
        return this.fieldBlockBuilders;
    }

    @Override
    protected Block getRawFieldBlock(int fieldIndex) {
        return this.fieldBlockBuilders[fieldIndex];
    }

    @Override
    protected int getRowIndex() {
        return this.rowIndex;
    }

    @Override
    public OptionalInt fixedSizeInBytesPerPosition() {
        return OptionalInt.empty();
    }

    @Override
    public long getSizeInBytes() {
        long currentBlockBuilderSize = 0L;
        for (BlockBuilder fieldBlockBuilder : this.fieldBlockBuilders) {
            currentBlockBuilderSize += fieldBlockBuilder.getSizeInBytes() - fieldBlockBuilder.getRegionSizeInBytes(0, this.rowIndex);
        }
        return currentBlockBuilderSize;
    }

    @Override
    public long getRetainedSizeInBytes() {
        long size = INSTANCE_SIZE;
        for (BlockBuilder fieldBlockBuilder : this.fieldBlockBuilders) {
            size += fieldBlockBuilder.getRetainedSizeInBytes();
        }
        return size;
    }

    @Override
    public void retainedBytesForEachPart(BiConsumer<Object, Long> consumer) {
        for (BlockBuilder fieldBlockBuilder : this.fieldBlockBuilders) {
            consumer.accept(fieldBlockBuilder, fieldBlockBuilder.getRetainedSizeInBytes());
        }
        consumer.accept(this, Long.valueOf(INSTANCE_SIZE));
    }

    @Override
    public BlockBuilder writeByte(int value) {
        this.checkFieldIndexToWrite();
        this.fieldBlockBuilders[this.currentFieldIndexToWrite].writeByte(value);
        return this;
    }

    @Override
    public BlockBuilder writeShort(int value) {
        this.checkFieldIndexToWrite();
        this.fieldBlockBuilders[this.currentFieldIndexToWrite].writeShort(value);
        return this;
    }

    @Override
    public BlockBuilder writeInt(int value) {
        this.checkFieldIndexToWrite();
        this.fieldBlockBuilders[this.currentFieldIndexToWrite].writeInt(value);
        return this;
    }

    @Override
    public BlockBuilder writeLong(long value) {
        this.checkFieldIndexToWrite();
        this.fieldBlockBuilders[this.currentFieldIndexToWrite].writeLong(value);
        return this;
    }

    @Override
    public BlockBuilder writeBytes(Slice source, int sourceIndex, int length) {
        this.checkFieldIndexToWrite();
        this.fieldBlockBuilders[this.currentFieldIndexToWrite].writeBytes(source, sourceIndex, length);
        return this;
    }

    @Override
    public BlockBuilder beginBlockEntry() {
        this.checkFieldIndexToWrite();
        return this.fieldBlockBuilders[this.currentFieldIndexToWrite].beginBlockEntry();
    }

    @Override
    public BlockBuilder appendNull() {
        this.checkFieldIndexToWrite();
        this.fieldBlockBuilders[this.currentFieldIndexToWrite].appendNull();
        this.entryAdded();
        return this;
    }

    @Override
    public BlockBuilder closeEntry() {
        this.checkFieldIndexToWrite();
        this.fieldBlockBuilders[this.currentFieldIndexToWrite].closeEntry();
        this.entryAdded();
        return this;
    }

    private void entryAdded() {
        ++this.currentFieldIndexToWrite;
    }

    @Override
    public int getPositionCount() {
        if (this.fieldBlockBuilderReturned) {
            throw new IllegalStateException("field block builder has been returned");
        }
        return this.currentFieldIndexToWrite;
    }

    @Override
    public String getEncodingName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Block build() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BlockBuilder newBlockBuilderLike(BlockBuilderStatus blockBuilderStatus) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        if (!this.fieldBlockBuilderReturned) {
            return String.format("SingleRowBlockWriter{numFields=%d, fieldBlockBuilderReturned=false, positionCount=%d}", this.fieldBlockBuilders.length, this.getPositionCount());
        }
        return String.format("SingleRowBlockWriter{numFields=%d, fieldBlockBuilderReturned=true}", this.fieldBlockBuilders.length);
    }

    void setRowIndex(int rowIndex) {
        if (this.rowIndex != -1) {
            throw new IllegalStateException("SingleRowBlockWriter should be reset before usage");
        }
        this.rowIndex = rowIndex;
    }

    void reset() {
        if (this.rowIndex == -1) {
            throw new IllegalStateException("SingleRowBlockWriter is already reset");
        }
        this.rowIndex = -1;
        this.currentFieldIndexToWrite = 0;
        this.fieldBlockBuilderReturned = false;
    }

    private void checkFieldIndexToWrite() {
        if (this.fieldBlockBuilderReturned) {
            throw new IllegalStateException("cannot do sequential write after getFieldBlockBuilder is called");
        }
        if (this.currentFieldIndexToWrite >= this.fieldBlockBuilders.length) {
            throw new IllegalStateException("currentFieldIndexToWrite is not valid");
        }
    }
}

