/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.predicate;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.airlift.slice.SizeOf;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.NullableValue;
import io.trino.spi.predicate.ToStringSession;
import io.trino.spi.type.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToLongFunction;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.openjdk.jol.info.ClassLayout;

public final class TupleDomain<T> {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(TupleDomain.class).instanceSize();
    private static final TupleDomain<?> NONE = new TupleDomain(Optional.empty());
    private static final TupleDomain<?> ALL = new TupleDomain(Optional.of(Collections.emptyMap()));
    private final Optional<Map<T, Domain>> domains;

    private TupleDomain(Optional<Map<T, Domain>> domains) {
        Objects.requireNonNull(domains, "domains is null");
        this.domains = domains.flatMap(map -> {
            if (TupleDomain.containsNoneDomain(map)) {
                return Optional.empty();
            }
            return Optional.of(Collections.unmodifiableMap(TupleDomain.normalizeAndCopy(map)));
        });
    }

    public static <T> TupleDomain<T> withColumnDomains(Map<T, Domain> domains) {
        Objects.requireNonNull(domains, "domains is null");
        if (domains.isEmpty()) {
            return TupleDomain.all();
        }
        return new TupleDomain<T>(Optional.of(domains));
    }

    public static <T> TupleDomain<T> none() {
        return NONE;
    }

    public static <T> TupleDomain<T> all() {
        return ALL;
    }

    public static <T> Optional<Map<T, NullableValue>> extractFixedValues(TupleDomain<T> tupleDomain) {
        if (tupleDomain.getDomains().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(tupleDomain.getDomains().get().entrySet().stream().filter((? super T entry) -> ((Domain)entry.getValue()).isNullableSingleValue()).collect(TupleDomain.toLinkedMap(Map.Entry::getKey, entry -> new NullableValue(((Domain)entry.getValue()).getType(), ((Domain)entry.getValue()).getNullableSingleValue()))));
    }

    public static <T> Optional<Map<T, List<NullableValue>>> extractDiscreteValues(TupleDomain<T> tupleDomain) {
        if (tupleDomain.getDomains().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(tupleDomain.getDomains().get().entrySet().stream().filter((? super T entry) -> ((Domain)entry.getValue()).isNullableDiscreteSet()).collect(TupleDomain.toLinkedMap(Map.Entry::getKey, entry -> {
            Domain.DiscreteSet discreteValues = ((Domain)entry.getValue()).getNullableDiscreteSet();
            ArrayList<NullableValue> nullableValues = new ArrayList<NullableValue>();
            for (Object value : discreteValues.getNonNullValues()) {
                nullableValues.add(new NullableValue(((Domain)entry.getValue()).getType(), value));
            }
            if (discreteValues.containsNull()) {
                nullableValues.add(new NullableValue(((Domain)entry.getValue()).getType(), null));
            }
            return Collections.unmodifiableList(nullableValues);
        })));
    }

    public static <T> TupleDomain<T> fromFixedValues(Map<T, NullableValue> fixedValues) {
        return TupleDomain.withColumnDomains(fixedValues.entrySet().stream().collect(TupleDomain.toLinkedMap(Map.Entry::getKey, entry -> {
            Type type = ((NullableValue)entry.getValue()).getType();
            Object value = ((NullableValue)entry.getValue()).getValue();
            return value == null ? Domain.onlyNull(type) : Domain.singleValue(type, value);
        })));
    }

    @Deprecated
    @JsonCreator
    public static <T> TupleDomain<T> fromColumnDomains(@JsonProperty(value="columnDomains") Optional<List<ColumnDomain<T>>> columnDomains) {
        if (columnDomains.isEmpty()) {
            return TupleDomain.none();
        }
        return TupleDomain.withColumnDomains(columnDomains.get().stream().collect(TupleDomain.toLinkedMap(ColumnDomain::getColumn, ColumnDomain::getDomain)));
    }

    @Deprecated
    @JsonProperty
    public Optional<List<ColumnDomain<T>>> getColumnDomains() {
        return this.domains.map(map -> map.entrySet().stream().map(entry -> new ColumnDomain(entry.getKey(), (Domain)entry.getValue())).collect(Collectors.toUnmodifiableList()));
    }

    private static <T> boolean containsNoneDomain(Map<T, Domain> domains) {
        return domains.values().stream().anyMatch(Domain::isNone);
    }

    private static <T> Map<T, Domain> normalizeAndCopy(Map<T, Domain> domains) {
        return domains.entrySet().stream().filter((? super T entry) -> !((Domain)entry.getValue()).isAll()).collect(TupleDomain.toLinkedMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public boolean isAll() {
        return this.domains.isPresent() && this.domains.get().isEmpty();
    }

    public boolean isNone() {
        return this.domains.isEmpty();
    }

    @JsonIgnore
    public Optional<Map<T, Domain>> getDomains() {
        return this.domains;
    }

    public <U extends T> TupleDomain<T> intersect(TupleDomain<U> other) {
        return TupleDomain.intersect(List.of(this, other));
    }

    public static <T> TupleDomain<T> intersect(List<? extends TupleDomain<? extends T>> domains) {
        if (domains.isEmpty()) {
            return TupleDomain.all();
        }
        if (domains.size() == 1) {
            return TupleDomain.upcast(domains.get(0));
        }
        if (domains.stream().anyMatch(TupleDomain::isNone)) {
            return TupleDomain.none();
        }
        if (domains.stream().allMatch(domain -> domain.equals(domains.get(0)))) {
            return TupleDomain.upcast(domains.get(0));
        }
        List candidates = domains.stream().filter((? super T domain) -> !domain.isAll()).collect(Collectors.toList());
        if (candidates.isEmpty()) {
            return TupleDomain.all();
        }
        if (candidates.size() == 1) {
            return TupleDomain.upcast((TupleDomain)candidates.get(0));
        }
        LinkedHashMap<T, Domain> intersected = new LinkedHashMap<T, Domain>(((TupleDomain)candidates.get(0)).getDomains().get());
        for (int i = 1; i < candidates.size(); ++i) {
            for (Map.Entry<T, Domain> entry : ((TupleDomain)candidates.get(i)).getDomains().get().entrySet()) {
                Domain intersectionDomain = (Domain)intersected.get(entry.getKey());
                if (intersectionDomain == null) {
                    intersected.put(entry.getKey(), entry.getValue());
                    continue;
                }
                Domain intersect = intersectionDomain.intersect(entry.getValue());
                if (intersect.isNone()) {
                    return TupleDomain.none();
                }
                intersected.put(entry.getKey(), intersect);
            }
        }
        return TupleDomain.withColumnDomains(intersected);
    }

    private static <U, T extends U> TupleDomain<U> upcast(TupleDomain<T> domain) {
        return domain;
    }

    @SafeVarargs
    public static <T> TupleDomain<T> columnWiseUnion(TupleDomain<T> first, TupleDomain<T> second, TupleDomain<T> ... rest) {
        ArrayList<TupleDomain<T>> domains = new ArrayList<TupleDomain<T>>(rest.length + 2);
        domains.add(first);
        domains.add(second);
        domains.addAll(Arrays.asList(rest));
        return TupleDomain.columnWiseUnion(domains);
    }

    public static <T> Optional<TupleDomain<T>> maximal(List<TupleDomain<T>> domains) {
        if (domains.isEmpty()) {
            return Optional.empty();
        }
        TupleDomain<T> largest = domains.get(0);
        for (int i = 1; i < domains.size(); ++i) {
            TupleDomain<T> current = domains.get(i);
            if (current.contains(largest)) {
                largest = current;
                continue;
            }
            if (largest.contains(current)) continue;
            return Optional.empty();
        }
        return Optional.of(largest);
    }

    public static <T> TupleDomain<T> columnWiseUnion(List<TupleDomain<T>> tupleDomains) {
        TupleDomain<T> domain;
        if (tupleDomains.isEmpty()) {
            throw new IllegalArgumentException("tupleDomains must have at least one element");
        }
        if (tupleDomains.size() == 1) {
            return tupleDomains.get(0);
        }
        HashSet<T> commonColumns = new HashSet<T>();
        boolean found = false;
        Iterator<TupleDomain<T>> domains = tupleDomains.iterator();
        while (domains.hasNext()) {
            domain = domains.next();
            if (domain.isAll()) {
                return TupleDomain.all();
            }
            if (domain.isNone()) continue;
            found = true;
            commonColumns.addAll(domain.getDomains().get().keySet());
            break;
        }
        if (!found) {
            return TupleDomain.none();
        }
        while (domains.hasNext()) {
            domain = domains.next();
            if (domain.isNone()) continue;
            commonColumns.retainAll(domain.getDomains().get().keySet());
        }
        LinkedHashMap<T, ArrayList<Domain>> domainsByColumn = new LinkedHashMap<T, ArrayList<Domain>>(tupleDomains.size());
        for (TupleDomain<T> domain2 : tupleDomains) {
            if (domain2.isNone()) continue;
            for (Map.Entry<T, Domain> entry : domain2.getDomains().get().entrySet()) {
                if (!commonColumns.contains(entry.getKey())) continue;
                ArrayList<Domain> domainForColumn = (ArrayList<Domain>)domainsByColumn.get(entry.getKey());
                if (domainForColumn == null) {
                    domainForColumn = new ArrayList<Domain>();
                    domainsByColumn.put(entry.getKey(), domainForColumn);
                }
                domainForColumn.add(entry.getValue());
            }
        }
        LinkedHashMap result = new LinkedHashMap(domainsByColumn.size());
        for (Map.Entry entry : domainsByColumn.entrySet()) {
            result.put(entry.getKey(), Domain.union((List)entry.getValue()));
        }
        return TupleDomain.withColumnDomains(result);
    }

    public boolean overlaps(TupleDomain<T> other) {
        Objects.requireNonNull(other, "other is null");
        if (this.isNone() || other.isNone()) {
            return false;
        }
        if (this == other || this.isAll() || other.isAll()) {
            return true;
        }
        Map<T, Domain> thisDomains = this.domains.orElseThrow();
        Map<T, Domain> otherDomains = other.getDomains().orElseThrow();
        for (Map.Entry<T, Domain> entry : otherDomains.entrySet()) {
            Domain commonColumnDomain = thisDomains.get(entry.getKey());
            if (commonColumnDomain == null || commonColumnDomain.overlaps(entry.getValue())) continue;
            return false;
        }
        return true;
    }

    public boolean contains(TupleDomain<T> other) {
        if (other.isNone() || this == other) {
            return true;
        }
        if (this.isNone()) {
            return false;
        }
        Map<T, Domain> thisDomains = this.domains.orElseThrow();
        Map<T, Domain> otherDomains = other.getDomains().orElseThrow();
        for (Map.Entry<T, Domain> entry : thisDomains.entrySet()) {
            Domain otherDomain = otherDomains.get(entry.getKey());
            if (otherDomain != null && entry.getValue().contains(otherDomain)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TupleDomain other = (TupleDomain)obj;
        return Objects.equals(this.domains, other.domains);
    }

    public int hashCode() {
        return Objects.hash(this.domains);
    }

    public String toString() {
        return this.toString(ToStringSession.INSTANCE);
    }

    public String toString(ConnectorSession session) {
        if (this.isAll()) {
            return "ALL";
        }
        if (this.isNone()) {
            return "NONE";
        }
        return this.domains.orElseThrow().entrySet().stream().collect(TupleDomain.toLinkedMap(Map.Entry::getKey, entry -> ((Domain)entry.getValue()).toString(session))).toString();
    }

    public TupleDomain<T> filter(BiPredicate<T, Domain> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return this.transformDomains((key, domain) -> {
            if (!predicate.test((Object)key, (Domain)domain)) {
                return Domain.all(domain.getType());
            }
            return domain;
        });
    }

    public <U> TupleDomain<U> transformKeys(Function<T, U> function) {
        if (this.isNone()) {
            return TupleDomain.none();
        }
        if (this.isAll()) {
            return TupleDomain.all();
        }
        Map<T, Domain> domains = this.domains.orElseThrow();
        LinkedHashMap<U, Domain> result = new LinkedHashMap<U, Domain>(domains.size());
        for (Map.Entry entry : domains.entrySet()) {
            U key = function.apply(entry.getKey());
            Objects.requireNonNull(key, () -> String.format("mapping function %s returned null for %s", function, entry.getKey()));
            Domain previous = result.put(key, entry.getValue());
            if (previous == null) continue;
            throw new IllegalArgumentException(String.format("Every argument must have a unique mapping. %s maps to %s and %s", entry.getKey(), entry.getValue(), previous));
        }
        return TupleDomain.withColumnDomains(result);
    }

    public TupleDomain<T> simplify() {
        return this.transformDomains((key, domain) -> domain.simplify());
    }

    public TupleDomain<T> simplify(int threshold) {
        return this.transformDomains((key, domain) -> domain.simplify(threshold));
    }

    public TupleDomain<T> transformDomains(BiFunction<T, Domain, Domain> transformation) {
        Objects.requireNonNull(transformation, "transformation is null");
        if (this.isNone() || this.isAll()) {
            return this;
        }
        return TupleDomain.withColumnDomains(this.domains.get().entrySet().stream().collect(TupleDomain.toLinkedMap(Map.Entry::getKey, entry -> {
            Domain newDomain = (Domain)transformation.apply(entry.getKey(), (Domain)entry.getValue());
            return Objects.requireNonNull(newDomain, "newDomain is null");
        })));
    }

    public Predicate<Map<T, NullableValue>> asPredicate() {
        if (this.isNone()) {
            return bindings -> false;
        }
        Map domains = this.domains.orElseThrow();
        return bindings -> {
            for (Map.Entry entry : bindings.entrySet()) {
                Domain domain = (Domain)domains.get(entry.getKey());
                if (domain == null || domain.includesNullableValue(((NullableValue)entry.getValue()).getValue())) continue;
                return false;
            }
            return true;
        };
    }

    private static <T, K, U> Collector<T, ?, Map<K, U>> toLinkedMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper) {
        return Collectors.toMap(keyMapper, valueMapper, (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate values for a key: %s and %s", u, v));
        }, LinkedHashMap::new);
    }

    public long getRetainedSizeInBytes(ToLongFunction<T> keySize) {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf(this.domains, value -> SizeOf.estimatedSizeOf((Map)value, (ToLongFunction)keySize, Domain::getRetainedSizeInBytes));
    }

    public static class ColumnDomain<C> {
        private final C column;
        private final Domain domain;

        @JsonCreator
        public ColumnDomain(@JsonProperty(value="column") C column, @JsonProperty(value="domain") Domain domain) {
            this.column = Objects.requireNonNull(column, "column is null");
            this.domain = Objects.requireNonNull(domain, "domain is null");
        }

        @JsonProperty
        public C getColumn() {
            return this.column;
        }

        @JsonProperty
        public Domain getDomain() {
            return this.domain;
        }
    }
}

