/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.security;

import io.trino.spi.security.ConnectorIdentity;
import io.trino.spi.security.SelectedRole;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;

public class Identity {
    private final String user;
    private final Set<String> groups;
    private final Optional<Principal> principal;
    private final Set<String> enabledRoles;
    private final Map<String, SelectedRole> catalogRoles;
    private final Map<String, String> extraCredentials;
    private final Optional<Runnable> onDestroy;

    private Identity(String user, Set<String> groups, Optional<Principal> principal, Set<String> enabledRoles, Map<String, SelectedRole> catalogRoles, Map<String, String> extraCredentials, Optional<Runnable> onDestroy) {
        this.user = Objects.requireNonNull(user, "user is null");
        this.groups = Set.copyOf((Collection)Objects.requireNonNull(groups, "groups is null"));
        this.principal = Objects.requireNonNull(principal, "principal is null");
        this.enabledRoles = Set.copyOf((Collection)Objects.requireNonNull(enabledRoles, "enabledRoles is null"));
        this.catalogRoles = Map.copyOf(Objects.requireNonNull(catalogRoles, "connectorRoles is null"));
        this.extraCredentials = Map.copyOf(Objects.requireNonNull(extraCredentials, "extraCredentials is null"));
        this.onDestroy = Objects.requireNonNull(onDestroy, "onDestroy is null");
    }

    public String getUser() {
        return this.user;
    }

    public Set<String> getGroups() {
        return this.groups;
    }

    public Optional<Principal> getPrincipal() {
        return this.principal;
    }

    public Set<String> getEnabledRoles() {
        return this.enabledRoles;
    }

    @Deprecated
    public Map<String, SelectedRole> getRoles() {
        return this.getCatalogRoles();
    }

    public Map<String, SelectedRole> getCatalogRoles() {
        return this.catalogRoles;
    }

    public Map<String, String> getExtraCredentials() {
        return this.extraCredentials;
    }

    public ConnectorIdentity toConnectorIdentity() {
        return ConnectorIdentity.forUser(this.user).withGroups(this.groups).withPrincipal(this.principal).withEnabledSystemRoles(this.enabledRoles).withExtraCredentials(this.extraCredentials).build();
    }

    public ConnectorIdentity toConnectorIdentity(String catalog) {
        return ConnectorIdentity.forUser(this.user).withGroups(this.groups).withPrincipal(this.principal).withEnabledSystemRoles(this.enabledRoles).withConnectorRole(Optional.ofNullable(this.catalogRoles.get(catalog))).withExtraCredentials(this.extraCredentials).build();
    }

    public void destroy() {
        this.onDestroy.ifPresent(Runnable::run);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Identity identity = (Identity)o;
        return Objects.equals(this.user, identity.user);
    }

    public int hashCode() {
        return Objects.hash(this.user);
    }

    public String toString() {
        List filteredCredentials;
        StringBuilder sb = new StringBuilder("Identity{");
        sb.append("user='").append(this.user).append('\'');
        if (!this.groups.isEmpty()) {
            sb.append(", groups=").append(this.groups);
        }
        this.principal.ifPresent(principal -> sb.append(", principal=").append(principal));
        if (!this.catalogRoles.isEmpty()) {
            sb.append(", catalogRoles=").append(this.catalogRoles);
        }
        if (!this.enabledRoles.isEmpty()) {
            sb.append(", enabledRoles=").append(this.enabledRoles);
        }
        if ((filteredCredentials = (List)this.extraCredentials.keySet().stream().filter(key -> !key.contains("$internal")).collect(Collectors.toCollection(ArrayList::new))).size() != this.extraCredentials.size()) {
            filteredCredentials.add("...");
        }
        if (!this.extraCredentials.isEmpty()) {
            sb.append(", extraCredentials=").append(filteredCredentials);
        }
        sb.append('}');
        return sb.toString();
    }

    public static Identity ofUser(String user) {
        return new Builder(user).build();
    }

    public static Builder forUser(String user) {
        return new Builder(user);
    }

    public static Builder from(Identity identity) {
        return new Builder(identity.getUser()).withGroups(identity.getGroups()).withPrincipal(identity.getPrincipal()).withEnabledRoles(identity.enabledRoles).withConnectorRoles(identity.getCatalogRoles()).withExtraCredentials(identity.getExtraCredentials());
    }

    private static final class InvokeOnceRunnable
    implements Runnable {
        private final Runnable delegate;
        private final AtomicBoolean invoked = new AtomicBoolean();

        public InvokeOnceRunnable(Runnable delegate) {
            this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        }

        @Override
        public void run() {
            if (this.invoked.compareAndSet(false, true)) {
                this.delegate.run();
            }
        }
    }

    public static class Builder {
        private String user;
        private Set<String> groups = new HashSet<String>();
        private Optional<Principal> principal = Optional.empty();
        private Set<String> enabledRoles = new HashSet<String>();
        private Map<String, SelectedRole> connectorRoles = new HashMap<String, SelectedRole>();
        private Map<String, String> extraCredentials = new HashMap<String, String>();
        private Optional<Runnable> onDestroy = Optional.empty();

        public Builder(String user) {
            this.user = Objects.requireNonNull(user, "user is null");
        }

        public Builder withUser(String user) {
            this.user = Objects.requireNonNull(user, "user is null");
            return this;
        }

        public Builder withPrincipal(Principal principal) {
            return this.withPrincipal(Optional.of(Objects.requireNonNull(principal, "principal is null")));
        }

        public Builder withPrincipal(Optional<Principal> principal) {
            this.principal = Objects.requireNonNull(principal, "principal is null");
            return this;
        }

        public Builder withEnabledRoles(Set<String> enabledRoles) {
            enabledRoles = new HashSet<String>((Collection)Objects.requireNonNull(enabledRoles, "enabledRoles is null"));
            this.enabledRoles = new HashSet<String>((Collection)Objects.requireNonNull(enabledRoles, "enabledRoles is null"));
            return this;
        }

        @Deprecated
        public Builder withRole(String catalog, SelectedRole role) {
            return this.withConnectorRole(catalog, role);
        }

        @Deprecated
        public Builder withRoles(Map<String, SelectedRole> roles) {
            return this.withConnectorRoles(roles);
        }

        @Deprecated
        public Builder withAdditionalRoles(Map<String, SelectedRole> roles) {
            return this.withAdditionalConnectorRoles(roles);
        }

        public Builder withConnectorRole(String catalog, SelectedRole role) {
            Objects.requireNonNull(catalog, "catalog is null");
            Objects.requireNonNull(role, "role is null");
            if (this.connectorRoles.put(catalog, role) != null) {
                throw new IllegalStateException("There is already role set for " + catalog);
            }
            return this;
        }

        public Builder withConnectorRoles(Map<String, SelectedRole> roles) {
            this.connectorRoles = new HashMap<String, SelectedRole>(Objects.requireNonNull(roles, "roles is null"));
            return this;
        }

        public Builder withAdditionalConnectorRoles(Map<String, SelectedRole> roles) {
            this.connectorRoles.putAll(Objects.requireNonNull(roles, "roles is null"));
            return this;
        }

        public Builder withExtraCredentials(Map<String, String> extraCredentials) {
            this.extraCredentials = new HashMap<String, String>(Objects.requireNonNull(extraCredentials, "extraCredentials is null"));
            return this;
        }

        public Builder withAdditionalExtraCredentials(Map<String, String> extraCredentials) {
            this.extraCredentials.putAll(Objects.requireNonNull(extraCredentials, "extraCredentials is null"));
            return this;
        }

        public void withOnDestroy(Runnable onDestroy) {
            Objects.requireNonNull(onDestroy, "onDestroy is null");
            if (this.onDestroy.isPresent()) {
                throw new IllegalStateException("Destroy callback already set");
            }
            this.onDestroy = Optional.of(new InvokeOnceRunnable(onDestroy));
        }

        public Builder withGroups(Set<String> groups) {
            this.groups = new HashSet<String>((Collection)Objects.requireNonNull(groups, "groups is null"));
            return this;
        }

        public Builder withAdditionalGroups(Set<String> groups) {
            this.groups.addAll((Collection<String>)Objects.requireNonNull(groups, "groups is null"));
            return this;
        }

        public Identity build() {
            return new Identity(this.user, this.groups, this.principal, this.enabledRoles, this.connectorRoles, this.extraCredentials, this.onDestroy);
        }
    }
}

