/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file;

import alluxio.AlluxioURI;
import alluxio.client.file.BaseFileSystem;
import alluxio.client.file.FileOutStream;
import alluxio.client.file.FileSystemContext;
import alluxio.client.file.MetadataCache;
import alluxio.client.file.URIStatus;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.exception.AlluxioException;
import alluxio.exception.FileAlreadyExistsException;
import alluxio.exception.FileDoesNotExistException;
import alluxio.exception.InvalidPathException;
import alluxio.grpc.Bits;
import alluxio.grpc.CreateDirectoryPOptions;
import alluxio.grpc.CreateFilePOptions;
import alluxio.grpc.DeletePOptions;
import alluxio.grpc.GetStatusPOptions;
import alluxio.grpc.ListStatusPOptions;
import alluxio.grpc.RenamePOptions;
import alluxio.metrics.MetricKey;
import alluxio.metrics.MetricsSystem;
import alluxio.shaded.client.com.google.common.annotations.VisibleForTesting;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import alluxio.util.FileSystemOptions;
import alluxio.util.ThreadUtils;
import alluxio.wire.FileInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class MetadataCachingBaseFileSystem
extends BaseFileSystem {
    private static final Logger LOG = LoggerFactory.getLogger(BaseFileSystem.class);
    private static final int THREAD_KEEPALIVE_SECOND = 60;
    private static final int THREAD_TERMINATION_TIMEOUT_MS = 10000;
    private static final URIStatus NOT_FOUND_STATUS = new URIStatus(new FileInfo().setCompleted(true));
    private final MetadataCache mMetadataCache;
    private final ExecutorService mAccessTimeUpdater;
    private final boolean mDisableUpdateFileAccessTime;

    public MetadataCachingBaseFileSystem(FileSystemContext context) {
        super(context);
        int maxSize = this.mFsContext.getClusterConf().getInt(PropertyKey.USER_METADATA_CACHE_MAX_SIZE);
        long expirationTimeMs = this.mFsContext.getClusterConf().getMs(PropertyKey.USER_METADATA_CACHE_EXPIRATION_TIME);
        this.mMetadataCache = new MetadataCache(maxSize, expirationTimeMs);
        int masterClientThreads = this.mFsContext.getClusterConf().getInt(PropertyKey.USER_FILE_MASTER_CLIENT_POOL_SIZE_MAX);
        this.mDisableUpdateFileAccessTime = this.mFsContext.getClusterConf().getBoolean(PropertyKey.USER_UPDATE_FILE_ACCESSTIME_DISABLED);
        this.mAccessTimeUpdater = new ThreadPoolExecutor(0, masterClientThreads, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
        MetricsSystem.registerCachedGaugeIfAbsent(MetricsSystem.getMetricName(MetricKey.CLIENT_META_DATA_CACHE_SIZE.getName()), this.mMetadataCache::size);
    }

    @Override
    public void createDirectory(AlluxioURI path, CreateDirectoryPOptions options) throws FileAlreadyExistsException, InvalidPathException, IOException, AlluxioException {
        this.mMetadataCache.invalidate(path.getParent());
        this.mMetadataCache.invalidate(path);
        super.createDirectory(path, options);
    }

    @Override
    public FileOutStream createFile(AlluxioURI path, CreateFilePOptions options) throws IOException, AlluxioException {
        this.mMetadataCache.invalidate(path.getParent());
        this.mMetadataCache.invalidate(path);
        return super.createFile(path, options);
    }

    @Override
    public void delete(AlluxioURI path, DeletePOptions options) throws IOException, AlluxioException {
        this.mMetadataCache.invalidate(path.getParent());
        this.mMetadataCache.invalidate(path);
        super.delete(path, options);
    }

    @Override
    public void rename(AlluxioURI src, AlluxioURI dst, RenamePOptions options) throws IOException, AlluxioException {
        this.mMetadataCache.invalidate(src.getParent());
        this.mMetadataCache.invalidate(src);
        this.mMetadataCache.invalidate(dst.getParent());
        this.mMetadataCache.invalidate(dst);
        super.rename(src, dst, options);
    }

    @Override
    public URIStatus getStatus(AlluxioURI path, GetStatusPOptions options) throws FileDoesNotExistException, IOException, AlluxioException {
        this.checkUri(path);
        URIStatus status = this.mMetadataCache.get(path);
        if (status == null || !status.isCompleted()) {
            try {
                status = super.getStatus(path, options);
                this.mMetadataCache.put(path, status);
            }
            catch (FileDoesNotExistException e) {
                this.mMetadataCache.put(path, NOT_FOUND_STATUS);
                throw e;
            }
        } else {
            if (status == NOT_FOUND_STATUS) {
                throw new FileDoesNotExistException("Path \"" + path.getPath() + "\" does not exist.");
            }
            if (options.getUpdateTimestamps()) {
                this.asyncUpdateFileAccessTime(path);
            }
        }
        return status;
    }

    @Override
    public void iterateStatus(AlluxioURI path, ListStatusPOptions options, Consumer<? super URIStatus> action) throws FileDoesNotExistException, IOException, AlluxioException {
        this.checkUri(path);
        if (options.getRecursive()) {
            super.iterateStatus(path, options, action);
            return;
        }
        List<URIStatus> cachedStatuses = this.mMetadataCache.listStatus(path);
        if (cachedStatuses == null) {
            ArrayList<URIStatus> statuses = new ArrayList<URIStatus>();
            super.iterateStatus(path, options, status -> {
                statuses.add((URIStatus)status);
                action.accept((URIStatus)status);
            });
            this.mMetadataCache.put(path, statuses);
            return;
        }
        cachedStatuses.forEach(action);
    }

    @Override
    public List<URIStatus> listStatus(AlluxioURI path, ListStatusPOptions options) throws FileDoesNotExistException, IOException, AlluxioException {
        this.checkUri(path);
        if (options.getRecursive()) {
            return super.listStatus(path, options);
        }
        List<URIStatus> statuses = this.mMetadataCache.listStatus(path);
        if (statuses == null) {
            statuses = super.listStatus(path, options);
            this.mMetadataCache.put(path, statuses);
        }
        return statuses;
    }

    @VisibleForTesting
    public void asyncUpdateFileAccessTime(AlluxioURI path) {
        if (this.mDisableUpdateFileAccessTime) {
            return;
        }
        try {
            this.mAccessTimeUpdater.submit(() -> {
                try {
                    AlluxioConfiguration conf = this.mFsContext.getPathConf(path);
                    GetStatusPOptions getStatusOptions = FileSystemOptions.getStatusDefaults(conf).toBuilder().setAccessMode(Bits.READ).setUpdateTimestamps(true).build();
                    super.getStatus(path, getStatusOptions);
                }
                catch (AlluxioException | IOException e) {
                    LOG.error("Failed to update access time for " + path, (Throwable)e);
                }
            });
        }
        catch (RejectedExecutionException e) {
            LOG.warn("Failed to submit a task to update access time for {}: {}", (Object)path, (Object)e.toString());
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (!this.mClosed) {
            ThreadUtils.shutdownAndAwaitTermination(this.mAccessTimeUpdater, 10000L);
            super.close();
        }
    }
}

