/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.options;

import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.security.authorization.Mode;
import alluxio.shaded.client.com.google.common.base.MoreObjects;
import alluxio.shaded.client.com.google.common.base.Objects;
import alluxio.shaded.client.javax.annotation.concurrent.NotThreadSafe;
import alluxio.util.ModeUtils;

@NotThreadSafe
public final class MkdirsOptions {
    private boolean mCreateParent = true;
    private String mOwner = null;
    private String mGroup = null;
    private Mode mMode;

    public static MkdirsOptions defaults(AlluxioConfiguration conf) {
        return new MkdirsOptions(conf.get(PropertyKey.SECURITY_AUTHORIZATION_PERMISSION_UMASK));
    }

    private MkdirsOptions(String authUmask) {
        this.mMode = ModeUtils.applyDirectoryUMask(Mode.defaults(), authUmask);
    }

    public boolean getCreateParent() {
        return this.mCreateParent;
    }

    public String getOwner() {
        return this.mOwner;
    }

    public String getGroup() {
        return this.mGroup;
    }

    public Mode getMode() {
        return this.mMode;
    }

    public MkdirsOptions setCreateParent(boolean createParent) {
        this.mCreateParent = createParent;
        return this;
    }

    public MkdirsOptions setOwner(String owner) {
        this.mOwner = owner;
        return this;
    }

    public MkdirsOptions setGroup(String group) {
        this.mGroup = group;
        return this;
    }

    public MkdirsOptions setMode(Mode mode) {
        this.mMode = mode;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MkdirsOptions)) {
            return false;
        }
        MkdirsOptions that = (MkdirsOptions)o;
        return Objects.equal(this.mCreateParent, that.mCreateParent) && Objects.equal(this.mOwner, that.mOwner) && Objects.equal(this.mGroup, that.mGroup) && Objects.equal(this.mMode, that.mMode);
    }

    public int hashCode() {
        return Objects.hashCode(this.mCreateParent, this.mOwner, this.mGroup, this.mMode);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("createParent", this.mCreateParent).add("owner", this.mOwner).add("group", this.mGroup).add("mode", this.mMode).toString();
    }
}

