/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.com.codahale.metrics.graphite;

import alluxio.shaded.client.com.codahale.metrics.graphite.GraphiteSanitize;
import alluxio.shaded.client.com.codahale.metrics.graphite.GraphiteSender;
import alluxio.shaded.client.com.rabbitmq.client.Channel;
import alluxio.shaded.client.com.rabbitmq.client.Connection;
import alluxio.shaded.client.com.rabbitmq.client.ConnectionFactory;
import alluxio.shaded.client.com.rabbitmq.client.DefaultSocketConfigurator;
import java.io.IOException;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeoutException;

public class GraphiteRabbitMQ
implements GraphiteSender {
    private static final Integer DEFAULT_RABBIT_CONNECTION_TIMEOUT_MS = 500;
    private static final Integer DEFAULT_RABBIT_SOCKET_TIMEOUT_MS = 5000;
    private static final Integer DEFAULT_RABBIT_REQUESTED_HEARTBEAT_SEC = 10;
    private ConnectionFactory connectionFactory;
    private Connection connection;
    private Channel channel;
    private String exchange;
    private int failures;

    public GraphiteRabbitMQ(ConnectionFactory connectionFactory, String exchange) {
        this.connectionFactory = connectionFactory;
        this.exchange = exchange;
    }

    public GraphiteRabbitMQ(String rabbitHost, Integer rabbitPort, String rabbitUsername, String rabbitPassword, String exchange) {
        this(rabbitHost, rabbitPort, rabbitUsername, rabbitPassword, exchange, DEFAULT_RABBIT_CONNECTION_TIMEOUT_MS, DEFAULT_RABBIT_SOCKET_TIMEOUT_MS, DEFAULT_RABBIT_REQUESTED_HEARTBEAT_SEC);
    }

    public GraphiteRabbitMQ(String rabbitHost, Integer rabbitPort, String rabbitUsername, String rabbitPassword, String exchange, Integer rabbitConnectionTimeoutMS, final Integer rabbitSocketTimeoutMS, Integer rabbitRequestedHeartbeatInSeconds) {
        this.exchange = exchange;
        this.connectionFactory = new ConnectionFactory();
        this.connectionFactory.setSocketConfigurator(new DefaultSocketConfigurator(){

            @Override
            public void configure(Socket socket) throws IOException {
                super.configure(socket);
                socket.setSoTimeout(rabbitSocketTimeoutMS);
            }
        });
        this.connectionFactory.setConnectionTimeout(rabbitConnectionTimeoutMS);
        this.connectionFactory.setRequestedHeartbeat(rabbitRequestedHeartbeatInSeconds);
        this.connectionFactory.setHost(rabbitHost);
        this.connectionFactory.setPort(rabbitPort);
        this.connectionFactory.setUsername(rabbitUsername);
        this.connectionFactory.setPassword(rabbitPassword);
    }

    @Override
    public void connect() throws IllegalStateException, IOException {
        if (this.isConnected()) {
            throw new IllegalStateException("Already connected");
        }
        try {
            this.connection = this.connectionFactory.newConnection();
        }
        catch (TimeoutException e) {
            throw new IllegalStateException(e);
        }
        this.channel = this.connection.createChannel();
    }

    @Override
    public boolean isConnected() {
        return this.connection != null && this.connection.isOpen();
    }

    @Override
    public void send(String name, String value, long timestamp) throws IOException {
        try {
            String sanitizedName = this.sanitize(name);
            String sanitizedValue = this.sanitize(value);
            String message = sanitizedName + ' ' + sanitizedValue + ' ' + Long.toString(timestamp) + '\n';
            this.channel.basicPublish(this.exchange, sanitizedName, null, message.getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            ++this.failures;
            throw e;
        }
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
        if (this.connection != null) {
            this.connection.close();
        }
    }

    @Override
    public int getFailures() {
        return this.failures;
    }

    public String sanitize(String s2) {
        return GraphiteSanitize.sanitize(s2);
    }
}

