/*
 * Decompiled with CFR 0.152.
 */
package alluxio.table;

import alluxio.grpc.table.Layout;
import alluxio.grpc.table.Partition;
import alluxio.grpc.table.Transformation;
import alluxio.grpc.table.layout.hive.PartitionInfo;
import alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException;
import java.util.List;
import java.util.Objects;

public final class ProtoUtils {
    public static boolean hasHiveLayout(Partition partition) {
        if (!partition.hasBaseLayout()) {
            return false;
        }
        Layout layout = partition.getBaseLayout();
        return Objects.equals(layout.getLayoutType(), "hive");
    }

    public static boolean isHiveLayout(Layout layout) {
        return Objects.equals(layout.getLayoutType(), "hive");
    }

    private static Layout getCurrentLayout(Partition partition) {
        List<Transformation> transformations = partition.getTransformationsList();
        return transformations.isEmpty() ? partition.getBaseLayout() : transformations.get(transformations.size() - 1).getLayout();
    }

    public static PartitionInfo extractHiveLayout(Partition partition) throws InvalidProtocolBufferException {
        if (!ProtoUtils.hasHiveLayout(partition)) {
            if (partition.hasBaseLayout()) {
                throw new IllegalStateException("Cannot parse hive-layout. layoutType: " + partition.getBaseLayout().getLayoutType());
            }
            throw new IllegalStateException("Cannot parse hive-layout from missing layout");
        }
        Layout layout = ProtoUtils.getCurrentLayout(partition);
        if (!layout.hasLayoutData()) {
            throw new IllegalStateException("Cannot parse hive-layout from empty layout data");
        }
        return PartitionInfo.parseFrom(layout.getLayoutData());
    }

    public static PartitionInfo toHiveLayout(Layout layout) throws InvalidProtocolBufferException {
        if (!ProtoUtils.isHiveLayout(layout)) {
            throw new IllegalStateException("Cannot parse hive-layout. layoutType: " + layout.getLayoutType());
        }
        if (!layout.hasLayoutData()) {
            throw new IllegalStateException("Cannot parse hive-layout from empty layout data");
        }
        return PartitionInfo.parseFrom(layout.getLayoutData());
    }
}

