/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.com.esri.core.geometry.ogc;

import com.linkedin.coral.com.esri.core.geometry.Geometry;
import com.linkedin.coral.com.esri.core.geometry.GeometryEngine;
import com.linkedin.coral.com.esri.core.geometry.Operator;
import com.linkedin.coral.com.esri.core.geometry.OperatorExportToWkb;
import com.linkedin.coral.com.esri.core.geometry.OperatorFactoryLocal;
import com.linkedin.coral.com.esri.core.geometry.Polygon;
import com.linkedin.coral.com.esri.core.geometry.Polyline;
import com.linkedin.coral.com.esri.core.geometry.SpatialReference;
import com.linkedin.coral.com.esri.core.geometry.ogc.OGCGeometry;
import com.linkedin.coral.com.esri.core.geometry.ogc.OGCLineString;
import com.linkedin.coral.com.esri.core.geometry.ogc.OGCLinearRing;
import com.linkedin.coral.com.esri.core.geometry.ogc.OGCMultiCurve;
import com.linkedin.coral.com.esri.core.geometry.ogc.OGCMultiPolygon;
import com.linkedin.coral.com.esri.core.geometry.ogc.OGCSurface;
import java.nio.ByteBuffer;

public class OGCPolygon
extends OGCSurface {
    public static String TYPE = "Polygon";
    Polygon polygon;

    public OGCPolygon(Polygon src, int exteriorRing, SpatialReference sr) {
        this.polygon = new Polygon();
        int n = src.getPathCount();
        for (int i = exteriorRing; !(i >= n || i > exteriorRing && src.isExteriorRing(i)); ++i) {
            this.polygon.addPath(src, i, true);
        }
        this.esriSR = sr;
    }

    public OGCPolygon(Polygon geom, SpatialReference sr) {
        this.polygon = geom;
        if (geom.getExteriorRingCount() > 1) {
            throw new IllegalArgumentException("Polygon has to have one exterior ring. Simplify geom with OperatorSimplify.");
        }
        this.esriSR = sr;
    }

    @Override
    public String asText() {
        return GeometryEngine.geometryToWkt(this.getEsriGeometry(), 16);
    }

    @Override
    public ByteBuffer asBinary() {
        OperatorExportToWkb op = (OperatorExportToWkb)OperatorFactoryLocal.getInstance().getOperator(Operator.Type.ExportToWkb);
        return op.execute(16, this.getEsriGeometry(), null);
    }

    public OGCLineString exteriorRing() {
        if (this.polygon.isEmpty()) {
            return new OGCLinearRing((Polygon)this.polygon.createInstance(), 0, this.esriSR, true);
        }
        return new OGCLinearRing(this.polygon, 0, this.esriSR, true);
    }

    public int numInteriorRing() {
        return this.polygon.getPathCount() - 1;
    }

    public OGCLineString interiorRingN(int n) {
        return new OGCLinearRing(this.polygon, n + 1, this.esriSR, true);
    }

    @Override
    public OGCMultiCurve boundary() {
        Polyline polyline = new Polyline();
        polyline.add(this.polygon, true);
        return (OGCMultiCurve)OGCGeometry.createFromEsriGeometry(polyline, this.esriSR, true);
    }

    @Override
    public String geometryType() {
        return TYPE;
    }

    @Override
    public long estimateMemorySize() {
        return 24L + (this.polygon != null ? this.polygon.estimateMemorySize() : 0L);
    }

    @Override
    public OGCGeometry locateAlong(double mValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OGCGeometry locateBetween(double mStart, double mEnd) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Geometry getEsriGeometry() {
        return this.polygon;
    }

    @Override
    public OGCGeometry convertToMulti() {
        return new OGCMultiPolygon(this.polygon, this.esriSR);
    }

    @Override
    public OGCGeometry reduceFromMulti() {
        return this;
    }
}

