/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import com.linkedin.coral.com.google.common.base.Preconditions;
import com.linkedin.coral.com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlOperandTypeInference;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.validate.SqlMonotonicity;

public class SqlGroupedWindowFunction
extends SqlFunction {
    public final SqlGroupedWindowFunction groupFunction;

    public SqlGroupedWindowFunction(String name, SqlKind kind, SqlGroupedWindowFunction groupFunction, SqlReturnTypeInference returnTypeInference, SqlOperandTypeInference operandTypeInference, SqlOperandTypeChecker operandTypeChecker, SqlFunctionCategory category) {
        super(name, kind, returnTypeInference, operandTypeInference, operandTypeChecker, category);
        this.groupFunction = groupFunction;
        Preconditions.checkArgument(groupFunction == null || groupFunction.groupFunction == null);
    }

    @Deprecated
    public SqlGroupedWindowFunction(String name, SqlKind kind, SqlGroupedWindowFunction groupFunction, SqlOperandTypeChecker operandTypeChecker) {
        this(name, kind, groupFunction, ReturnTypes.ARG0, null, operandTypeChecker, SqlFunctionCategory.SYSTEM);
    }

    @Deprecated
    public SqlGroupedWindowFunction(SqlKind kind, SqlGroupedWindowFunction groupFunction, SqlOperandTypeChecker operandTypeChecker) {
        this(kind.name(), kind, groupFunction, ReturnTypes.ARG0, null, operandTypeChecker, SqlFunctionCategory.SYSTEM);
    }

    public SqlGroupedWindowFunction auxiliary(SqlKind kind) {
        return this.auxiliary(kind.name(), kind);
    }

    public SqlGroupedWindowFunction auxiliary(String name, SqlKind kind) {
        return new SqlGroupedWindowFunction(name, kind, this, ReturnTypes.ARG0, null, this.getOperandTypeChecker(), SqlFunctionCategory.SYSTEM);
    }

    public List<SqlGroupedWindowFunction> getAuxiliaryFunctions() {
        return ImmutableList.of();
    }

    @Override
    public boolean isGroup() {
        return this.groupFunction == null;
    }

    @Override
    public boolean isGroupAuxiliary() {
        return this.groupFunction != null;
    }

    @Override
    public SqlMonotonicity getMonotonicity(SqlOperatorBinding call) {
        return call.getOperandMonotonicity(0).unstrict();
    }
}

