/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap.art;

import java.util.Iterator;
import org.roaringbitmap.art.Art;
import org.roaringbitmap.art.BackwardShuttle;
import org.roaringbitmap.art.Containers;
import org.roaringbitmap.art.ForwardShuttle;
import org.roaringbitmap.art.LeafNode;
import org.roaringbitmap.art.Shuttle;

public class LeafNodeIterator
implements Iterator<LeafNode> {
    private Shuttle shuttle;
    private LeafNode current;
    private boolean consumedCurrent;
    private boolean isEmpty;

    public LeafNodeIterator(Art art, Containers containers) {
        this(art, false, containers);
    }

    public LeafNodeIterator(Art art, boolean reverse, Containers containers) {
        this.isEmpty = art.isEmpty();
        if (this.isEmpty) {
            return;
        }
        this.shuttle = !reverse ? new ForwardShuttle(art, containers) : new BackwardShuttle(art, containers);
        this.shuttle.initShuttle();
        this.consumedCurrent = true;
    }

    @Override
    public boolean hasNext() {
        if (this.isEmpty) {
            return false;
        }
        if (!this.consumedCurrent) {
            return false;
        }
        boolean hasLeafNode = this.shuttle.moveToNextLeaf();
        if (hasLeafNode) {
            this.current = this.shuttle.getCurrentLeafNode();
            this.consumedCurrent = false;
        }
        return hasLeafNode;
    }

    @Override
    public LeafNode next() {
        this.consumedCurrent = true;
        return this.current;
    }

    @Override
    public void remove() {
        this.shuttle.remove();
    }
}

