/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.spark.status.impl;

import io.trino.hive.$internal.org.slf4j.Logger;
import io.trino.hive.$internal.org.slf4j.LoggerFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hive.ql.exec.spark.SparkUtilities;
import org.apache.hadoop.hive.ql.exec.spark.Statistic.SparkStatistics;
import org.apache.hadoop.hive.ql.exec.spark.Statistic.SparkStatisticsBuilder;
import org.apache.hadoop.hive.ql.exec.spark.status.SparkJobStatus;
import org.apache.hadoop.hive.ql.exec.spark.status.SparkStageProgress;
import org.apache.hadoop.hive.ql.exec.spark.status.impl.JobMetricsListener;
import org.apache.hadoop.hive.ql.exec.spark.status.impl.SparkMetricsUtils;
import org.apache.hive.spark.client.MetricsCollection;
import org.apache.hive.spark.client.metrics.Metrics;
import org.apache.hive.spark.counter.SparkCounters;
import org.apache.spark.JobExecutionStatus;
import org.apache.spark.SparkJobInfo;
import org.apache.spark.SparkStageInfo;
import org.apache.spark.api.java.JavaFutureAction;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.executor.TaskMetrics;
import org.apache.spark.scheduler.TaskInfo;

public class LocalSparkJobStatus
implements SparkJobStatus {
    private final JavaSparkContext sparkContext;
    private static final Logger LOG = LoggerFactory.getLogger(LocalSparkJobStatus.class.getName());
    private int jobId;
    private JobMetricsListener jobMetricsListener;
    private SparkCounters sparkCounters;
    private JavaFutureAction<Void> future;
    private Set<Integer> cachedRDDIds;
    private Throwable error;

    public LocalSparkJobStatus(JavaSparkContext sparkContext, int jobId, JobMetricsListener jobMetricsListener, SparkCounters sparkCounters, Set<Integer> cachedRDDIds, JavaFutureAction<Void> future) {
        this.sparkContext = sparkContext;
        this.jobId = jobId;
        this.jobMetricsListener = jobMetricsListener;
        this.sparkCounters = sparkCounters;
        this.cachedRDDIds = cachedRDDIds;
        this.future = future;
        this.error = null;
    }

    @Override
    public String getAppID() {
        return this.sparkContext.sc().applicationId();
    }

    @Override
    public int getJobId() {
        return this.jobId;
    }

    @Override
    public JobExecutionStatus getState() {
        SparkJobInfo sparkJobInfo = this.getJobInfo();
        if (sparkJobInfo == null && this.future.isDone()) {
            try {
                this.future.get();
            }
            catch (Exception e) {
                LOG.error("Failed to run job " + this.jobId, e);
                return JobExecutionStatus.FAILED;
            }
            return JobExecutionStatus.SUCCEEDED;
        }
        return sparkJobInfo == null ? null : sparkJobInfo.status();
    }

    @Override
    public int[] getStageIds() {
        SparkJobInfo sparkJobInfo = this.getJobInfo();
        return sparkJobInfo == null ? new int[]{} : sparkJobInfo.stageIds();
    }

    @Override
    public Map<String, SparkStageProgress> getSparkStageProgress() {
        HashMap<String, SparkStageProgress> stageProgresses = new HashMap<String, SparkStageProgress>();
        for (int stageId : this.getStageIds()) {
            SparkStageInfo sparkStageInfo = this.getStageInfo(stageId);
            if (sparkStageInfo == null) continue;
            int runningTaskCount = sparkStageInfo.numActiveTasks();
            int completedTaskCount = sparkStageInfo.numCompletedTasks();
            int failedTaskCount = sparkStageInfo.numFailedTasks();
            int totalTaskCount = sparkStageInfo.numTasks();
            SparkStageProgress sparkStageProgress = new SparkStageProgress(totalTaskCount, completedTaskCount, runningTaskCount, failedTaskCount);
            stageProgresses.put(String.valueOf(sparkStageInfo.stageId()) + "_" + sparkStageInfo.currentAttemptId(), sparkStageProgress);
        }
        return stageProgresses;
    }

    @Override
    public SparkCounters getCounter() {
        return this.sparkCounters;
    }

    @Override
    public SparkStatistics getSparkStatistics() {
        SparkStatisticsBuilder sparkStatisticsBuilder = new SparkStatisticsBuilder();
        sparkStatisticsBuilder.add(this.sparkCounters);
        Map<Integer, List<Map.Entry<TaskMetrics, TaskInfo>>> jobMetric = this.jobMetricsListener.getJobMetric(this.jobId);
        if (jobMetric == null) {
            return null;
        }
        MetricsCollection metricsCollection = new MetricsCollection();
        Set<Integer> stageIds = jobMetric.keySet();
        for (int stageId : stageIds) {
            List<Map.Entry<TaskMetrics, TaskInfo>> taskMetrics = jobMetric.get(stageId);
            for (Map.Entry<TaskMetrics, TaskInfo> taskMetric : taskMetrics) {
                Metrics metrics = new Metrics(taskMetric.getKey(), taskMetric.getValue());
                metricsCollection.addMetrics(this.jobId, stageId, 0L, metrics);
            }
        }
        Map<String, Long> flatJobMetric = SparkMetricsUtils.collectMetrics(metricsCollection.getAllMetrics());
        for (Map.Entry<String, Long> entry : flatJobMetric.entrySet()) {
            sparkStatisticsBuilder.add("SPARK", entry.getKey(), Long.toString(entry.getValue()));
        }
        return sparkStatisticsBuilder.build();
    }

    @Override
    public String getWebUIURL() {
        try {
            if (this.sparkContext.sc().uiWebUrl().isDefined()) {
                return SparkUtilities.reverseDNSLookupURL((String)this.sparkContext.sc().uiWebUrl().get());
            }
            return "UNDEFINED";
        }
        catch (Exception e) {
            LOG.warn("Failed to get web UI URL.", e);
            return "UNKNOWN";
        }
    }

    @Override
    public void cleanup() {
        this.jobMetricsListener.cleanup(this.jobId);
        if (this.cachedRDDIds != null) {
            for (Integer cachedRDDId : this.cachedRDDIds) {
                this.sparkContext.sc().unpersistRDD(cachedRDDId.intValue(), false);
            }
        }
    }

    @Override
    public Throwable getError() {
        if (this.error != null) {
            return this.error;
        }
        if (this.future.isDone()) {
            try {
                this.future.get();
            }
            catch (Throwable e) {
                return e;
            }
        }
        return null;
    }

    @Override
    public void setError(Throwable e) {
        this.error = e;
    }

    private SparkJobInfo getJobInfo() {
        return this.sparkContext.statusTracker().getJobInfo(this.jobId);
    }

    private SparkStageInfo getStageInfo(int stageId) {
        return this.sparkContext.statusTracker().getStageInfo(stageId);
    }
}

