/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.avro;

import io.trino.hive.$internal.com.google.common.cache.Cache;
import io.trino.hive.$internal.com.google.common.cache.CacheBuilder;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hive.serde2.avro.AvroSerdeException;

public abstract class InstanceCache<K, V> {
    private final Cache<K, V> cache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build();

    protected InstanceCache() {
    }

    public V retrieve(K hv) throws AvroSerdeException {
        return this.retrieve(hv, null);
    }

    public V retrieve(K hv, Set<K> seenSchemas) throws AvroSerdeException {
        V instance = this.cache.getIfPresent(hv);
        if (instance == null) {
            instance = this.makeInstance(hv, seenSchemas);
            this.cache.put(hv, instance);
        }
        return instance;
    }

    protected abstract V makeInstance(K var1, Set<K> var2) throws AvroSerdeException;
}

