/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.drift.protocol;

import io.airlift.drift.TException;
import io.airlift.drift.protocol.TField;
import io.airlift.drift.protocol.TList;
import io.airlift.drift.protocol.TMap;
import io.airlift.drift.protocol.TMessage;
import io.airlift.drift.protocol.TProtocol;
import io.airlift.drift.protocol.TProtocolException;
import io.airlift.drift.protocol.TSet;
import io.airlift.drift.protocol.TStruct;
import io.airlift.drift.protocol.TTransport;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Objects;

public class TFacebookCompactProtocol
implements TProtocol {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final TStruct ANONYMOUS_STRUCT = new TStruct("");
    private static final TField TSTOP = new TField("", 0, 0);
    private static final byte[] TTYPE_TO_COMPACT_TYPE = new byte[16];
    private static final byte PROTOCOL_ID = -126;
    private static final byte VERSION = 2;
    private static final byte VERSION_MASK = 31;
    private static final byte TYPE_MASK = -32;
    private static final byte TYPE_BITS = 3;
    private static final int TYPE_SHIFT_AMOUNT = 5;
    private final Deque<Short> lastField = new ArrayDeque<Short>();
    private short lastFieldId;
    private TField booleanField;
    private Boolean booleanValue;
    private final TTransport transport;
    private final byte[] i32buf = new byte[5];
    private final byte[] varint64out = new byte[10];
    private final byte[] byteDirectBuffer = new byte[1];
    private final byte[] byteRawBuf = new byte[1];
    private final byte[] doubleBuf = new byte[8];

    public TFacebookCompactProtocol(TTransport transport) {
        this.transport = Objects.requireNonNull(transport, "transport is null");
    }

    @Override
    public void writeMessageBegin(TMessage message) throws TException {
        this.writeByteDirect((byte)-126);
        this.writeByteDirect(2 | message.getType() << 5 & 0xFFFFFFE0);
        this.writeVarint32(message.getSequenceId());
        this.writeString(message.getName());
    }

    @Override
    public void writeStructBegin(TStruct struct) {
        this.lastField.push(this.lastFieldId);
        this.lastFieldId = 0;
    }

    @Override
    public void writeStructEnd() {
        this.lastFieldId = this.lastField.pop();
    }

    @Override
    public void writeFieldBegin(TField field) throws TException {
        if (field.getType() == 2) {
            this.booleanField = field;
        } else {
            this.writeFieldBeginInternal(field, (byte)-1);
        }
    }

    private void writeFieldBeginInternal(TField field, byte typeOverride) throws TException {
        byte typeToWrite;
        byte by = typeToWrite = typeOverride == -1 ? TFacebookCompactProtocol.getCompactType(field.getType()) : typeOverride;
        if (field.getId() > this.lastFieldId && field.getId() - this.lastFieldId <= 15) {
            this.writeByteDirect(field.getId() - this.lastFieldId << 4 | typeToWrite);
        } else {
            this.writeByteDirect(typeToWrite);
            this.writeI16(field.getId());
        }
        this.lastFieldId = field.getId();
    }

    @Override
    public void writeFieldStop() throws TException {
        this.writeByteDirect((byte)0);
    }

    @Override
    public void writeMapBegin(TMap map) throws TException {
        if (map.getSize() == 0) {
            this.writeByteDirect(0);
        } else {
            this.writeVarint32(map.getSize());
            this.writeByteDirect(TFacebookCompactProtocol.getCompactType(map.getKeyType()) << 4 | TFacebookCompactProtocol.getCompactType(map.getValueType()));
        }
    }

    @Override
    public void writeListBegin(TList list) throws TException {
        this.writeCollectionBegin(list.getType(), list.getSize());
    }

    @Override
    public void writeSetBegin(TSet set) throws TException {
        this.writeCollectionBegin(set.getType(), set.getSize());
    }

    @Override
    public void writeBool(boolean value) throws TException {
        if (this.booleanField != null) {
            this.writeFieldBeginInternal(this.booleanField, value ? (byte)1 : 2);
            this.booleanField = null;
        } else {
            this.writeByteDirect(value ? (byte)1 : 2);
        }
    }

    @Override
    public void writeByte(byte value) throws TException {
        this.writeByteDirect(value);
    }

    @Override
    public void writeI16(short value) throws TException {
        this.writeVarint32(TFacebookCompactProtocol.intToZigZag(value));
    }

    @Override
    public void writeI32(int value) throws TException {
        this.writeVarint32(TFacebookCompactProtocol.intToZigZag(value));
    }

    @Override
    public void writeI64(long value) throws TException {
        this.writeVarint64(TFacebookCompactProtocol.longToZigzag(value));
    }

    @Override
    public void writeDouble(double value) throws TException {
        byte[] data = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
        TFacebookCompactProtocol.fixedLongToBytes(Double.doubleToLongBits(value), data);
        this.transport.write(data);
    }

    @Override
    public void writeString(String value) throws TException {
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        this.writeBinary(bytes, 0, bytes.length);
    }

    @Override
    public void writeBinary(ByteBuffer value) throws TException {
        int length = value.limit() - value.position();
        this.writeBinary(value.array(), value.position() + value.arrayOffset(), length);
    }

    private void writeBinary(byte[] buf, int offset, int length) throws TException {
        this.writeVarint32(length);
        this.transport.write(buf, offset, length);
    }

    @Override
    public void writeMessageEnd() {
    }

    @Override
    public void writeMapEnd() {
    }

    @Override
    public void writeListEnd() {
    }

    @Override
    public void writeSetEnd() {
    }

    @Override
    public void writeFieldEnd() {
    }

    private void writeCollectionBegin(byte elemType, int size) throws TException {
        if (size <= 14) {
            this.writeByteDirect(size << 4 | TFacebookCompactProtocol.getCompactType(elemType));
        } else {
            this.writeByteDirect(0xF0 | TFacebookCompactProtocol.getCompactType(elemType));
            this.writeVarint32(size);
        }
    }

    private void writeVarint32(int n) throws TException {
        int idx = 0;
        while (true) {
            if ((n & 0xFFFFFF80) == 0) break;
            this.i32buf[idx++] = (byte)(n & 0x7F | 0x80);
            n >>>= 7;
        }
        this.i32buf[idx++] = (byte)n;
        this.transport.write(this.i32buf, 0, idx);
    }

    private void writeVarint64(long n) throws TException {
        int idx = 0;
        while (true) {
            if ((n & 0xFFFFFFFFFFFFFF80L) == 0L) break;
            this.varint64out[idx++] = (byte)(n & 0x7FL | 0x80L);
            n >>>= 7;
        }
        this.varint64out[idx++] = (byte)n;
        this.transport.write(this.varint64out, 0, idx);
    }

    private static long longToZigzag(long l) {
        return l << 1 ^ l >> 63;
    }

    private static int intToZigZag(int n) {
        return n << 1 ^ n >> 31;
    }

    private static void fixedLongToBytes(long n, byte[] buf) {
        buf[0] = (byte)(n >> 56 & 0xFFL);
        buf[1] = (byte)(n >> 48 & 0xFFL);
        buf[2] = (byte)(n >> 40 & 0xFFL);
        buf[3] = (byte)(n >> 32 & 0xFFL);
        buf[4] = (byte)(n >> 24 & 0xFFL);
        buf[5] = (byte)(n >> 16 & 0xFFL);
        buf[6] = (byte)(n >> 8 & 0xFFL);
        buf[7] = (byte)(n & 0xFFL);
    }

    private void writeByteDirect(byte b) throws TException {
        this.byteDirectBuffer[0] = b;
        this.transport.write(this.byteDirectBuffer);
    }

    private void writeByteDirect(int n) throws TException {
        this.writeByteDirect((byte)n);
    }

    @Override
    public TMessage readMessageBegin() throws TException {
        byte protocolId = this.readByte();
        if (protocolId != -126) {
            throw new TProtocolException("Expected protocol id " + Integer.toHexString(-126) + " but got " + Integer.toHexString(protocolId));
        }
        byte versionAndType = this.readByte();
        byte version = (byte)(versionAndType & 0x1F);
        if (version != 2) {
            throw new TProtocolException("Expected version 2 but got " + version);
        }
        byte type = (byte)(versionAndType >> 5 & 3);
        int seqid = this.readVarint32();
        String messageName = this.readString();
        return new TMessage(messageName, type, seqid);
    }

    @Override
    public TStruct readStructBegin() {
        this.lastField.push(this.lastFieldId);
        this.lastFieldId = 0;
        return ANONYMOUS_STRUCT;
    }

    @Override
    public void readStructEnd() {
        this.lastFieldId = this.lastField.pop();
    }

    @Override
    public TField readFieldBegin() throws TException {
        byte type = this.readByte();
        if (type == 0) {
            return TSTOP;
        }
        short modifier = (short)((type & 0xF0) >> 4);
        short fieldId = modifier == 0 ? this.readI16() : (short)(this.lastFieldId + modifier);
        TField field = new TField("", TFacebookCompactProtocol.getTType((byte)(type & 0xF)), fieldId);
        if (TFacebookCompactProtocol.isBoolType(type)) {
            this.booleanValue = (byte)(type & 0xF) == 1 ? Boolean.TRUE : Boolean.FALSE;
        }
        this.lastFieldId = field.getId();
        return field;
    }

    @Override
    public TMap readMapBegin() throws TException {
        int size = TFacebookCompactProtocol.checkSize(this.readVarint32());
        byte keyAndValueType = size == 0 ? (byte)0 : this.readByte();
        return new TMap(TFacebookCompactProtocol.getTType((byte)(keyAndValueType >> 4)), TFacebookCompactProtocol.getTType((byte)(keyAndValueType & 0xF)), size);
    }

    @Override
    public TList readListBegin() throws TException {
        byte sizeAndType = this.readByte();
        int size = sizeAndType >> 4 & 0xF;
        if (size == 15) {
            size = this.readVarint32();
        }
        TFacebookCompactProtocol.checkSize(size);
        byte type = TFacebookCompactProtocol.getTType(sizeAndType);
        return new TList(type, size);
    }

    @Override
    public TSet readSetBegin() throws TException {
        return new TSet(this.readListBegin());
    }

    @Override
    public boolean readBool() throws TException {
        if (this.booleanValue != null) {
            boolean result = this.booleanValue;
            this.booleanValue = null;
            return result;
        }
        return this.readByte() == 1;
    }

    @Override
    public byte readByte() throws TException {
        this.transport.read(this.byteRawBuf, 0, 1);
        return this.byteRawBuf[0];
    }

    @Override
    public short readI16() throws TException {
        return (short)TFacebookCompactProtocol.zigzagToInt(this.readVarint32());
    }

    @Override
    public int readI32() throws TException {
        return TFacebookCompactProtocol.zigzagToInt(this.readVarint32());
    }

    @Override
    public long readI64() throws TException {
        return TFacebookCompactProtocol.zigzagToLong(this.readVarint64());
    }

    @Override
    public double readDouble() throws TException {
        this.transport.read(this.doubleBuf, 0, 8);
        return Double.longBitsToDouble(TFacebookCompactProtocol.bytesToLong(this.doubleBuf));
    }

    @Override
    public String readString() throws TException {
        int length = TFacebookCompactProtocol.checkSize(this.readVarint32());
        if (length == 0) {
            return "";
        }
        return new String(this.readBinary(length), StandardCharsets.UTF_8);
    }

    @Override
    public ByteBuffer readBinary() throws TException {
        int length = TFacebookCompactProtocol.checkSize(this.readVarint32());
        if (length == 0) {
            return ByteBuffer.wrap(EMPTY_BYTE_ARRAY);
        }
        byte[] buf = new byte[length];
        this.transport.read(buf, 0, length);
        return ByteBuffer.wrap(buf);
    }

    private byte[] readBinary(int length) throws TException {
        if (length == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        byte[] buf = new byte[length];
        this.transport.read(buf, 0, length);
        return buf;
    }

    private static int checkSize(int length) throws TProtocolException {
        if (length < 0) {
            throw new TProtocolException("Negative length: " + length);
        }
        return length;
    }

    @Override
    public void readMessageEnd() {
    }

    @Override
    public void readFieldEnd() {
    }

    @Override
    public void readMapEnd() {
    }

    @Override
    public void readListEnd() {
    }

    @Override
    public void readSetEnd() {
    }

    private int readVarint32() throws TException {
        int result = 0;
        int shift = 0;
        while (true) {
            byte b = this.readByte();
            result |= (b & 0x7F) << shift;
            if ((b & 0x80) != 128) break;
            shift += 7;
        }
        return result;
    }

    private long readVarint64() throws TException {
        int shift = 0;
        long result = 0L;
        while (true) {
            byte b = this.readByte();
            result |= (long)(b & 0x7F) << shift;
            if ((b & 0x80) != 128) break;
            shift += 7;
        }
        return result;
    }

    private static int zigzagToInt(int n) {
        return n >>> 1 ^ -(n & 1);
    }

    private static long zigzagToLong(long n) {
        return n >>> 1 ^ -(n & 1L);
    }

    private static long bytesToLong(byte[] bytes) {
        return ((long)bytes[0] & 0xFFL) << 56 | ((long)bytes[1] & 0xFFL) << 48 | ((long)bytes[2] & 0xFFL) << 40 | ((long)bytes[3] & 0xFFL) << 32 | ((long)bytes[4] & 0xFFL) << 24 | ((long)bytes[5] & 0xFFL) << 16 | ((long)bytes[6] & 0xFFL) << 8 | (long)bytes[7] & 0xFFL;
    }

    private static boolean isBoolType(byte b) {
        int lowerNibble = b & 0xF;
        return lowerNibble == 1 || lowerNibble == 2;
    }

    private static byte getTType(byte type) throws TProtocolException {
        switch ((byte)(type & 0xF)) {
            case 0: {
                return 0;
            }
            case 1: 
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 6;
            }
            case 5: {
                return 8;
            }
            case 6: {
                return 10;
            }
            case 7: {
                return 4;
            }
            case 8: {
                return 11;
            }
            case 9: {
                return 15;
            }
            case 10: {
                return 14;
            }
            case 11: {
                return 13;
            }
            case 12: {
                return 12;
            }
        }
        throw new TProtocolException("don't know what type: " + (byte)(type & 0xF));
    }

    private static byte getCompactType(byte ttype) {
        return TTYPE_TO_COMPACT_TYPE[ttype];
    }

    static {
        TFacebookCompactProtocol.TTYPE_TO_COMPACT_TYPE[0] = 0;
        TFacebookCompactProtocol.TTYPE_TO_COMPACT_TYPE[2] = 1;
        TFacebookCompactProtocol.TTYPE_TO_COMPACT_TYPE[3] = 3;
        TFacebookCompactProtocol.TTYPE_TO_COMPACT_TYPE[6] = 4;
        TFacebookCompactProtocol.TTYPE_TO_COMPACT_TYPE[8] = 5;
        TFacebookCompactProtocol.TTYPE_TO_COMPACT_TYPE[10] = 6;
        TFacebookCompactProtocol.TTYPE_TO_COMPACT_TYPE[4] = 7;
        TFacebookCompactProtocol.TTYPE_TO_COMPACT_TYPE[11] = 8;
        TFacebookCompactProtocol.TTYPE_TO_COMPACT_TYPE[15] = 9;
        TFacebookCompactProtocol.TTYPE_TO_COMPACT_TYPE[14] = 10;
        TFacebookCompactProtocol.TTYPE_TO_COMPACT_TYPE[13] = 11;
        TFacebookCompactProtocol.TTYPE_TO_COMPACT_TYPE[12] = 12;
    }

    private static final class Types {
        public static final byte BOOLEAN_TRUE = 1;
        public static final byte BOOLEAN_FALSE = 2;
        public static final byte BYTE = 3;
        public static final byte I16 = 4;
        public static final byte I32 = 5;
        public static final byte I64 = 6;
        public static final byte DOUBLE = 7;
        public static final byte BINARY = 8;
        public static final byte LIST = 9;
        public static final byte SET = 10;
        public static final byte MAP = 11;
        public static final byte STRUCT = 12;

        private Types() {
        }
    }
}

