/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.raptor.legacy;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Injector;
import com.google.inject.Module;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.json.JsonModule;
import io.trino.plugin.base.CatalogNameModule;
import io.trino.plugin.base.jmx.ConnectorObjectNameGeneratorModule;
import io.trino.plugin.base.jmx.MBeanServerModule;
import io.trino.plugin.raptor.legacy.RaptorConnector;
import io.trino.plugin.raptor.legacy.RaptorModule;
import io.trino.plugin.raptor.legacy.backup.BackupModule;
import io.trino.plugin.raptor.legacy.security.RaptorSecurityModule;
import io.trino.plugin.raptor.legacy.storage.StorageModule;
import io.trino.spi.NodeManager;
import io.trino.spi.PageSorter;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorContext;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.type.TypeManager;
import java.util.Map;
import java.util.Objects;
import org.weakref.jmx.guice.MBeanModule;

public class RaptorConnectorFactory
implements ConnectorFactory {
    private final String name;
    private final Module metadataModule;
    private final Map<String, Module> backupProviders;

    public RaptorConnectorFactory(String name, Module metadataModule, Map<String, Module> backupProviders) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"name is null or empty");
        this.name = name;
        this.metadataModule = Objects.requireNonNull(metadataModule, "metadataModule is null");
        this.backupProviders = ImmutableMap.copyOf(Objects.requireNonNull(backupProviders, "backupProviders is null"));
    }

    public String getName() {
        return this.name;
    }

    public Connector create(String catalogName, Map<String, String> config, ConnectorContext context) {
        Bootstrap app = new Bootstrap(new Module[]{new CatalogNameModule(catalogName), new JsonModule(), new MBeanModule(), new ConnectorObjectNameGeneratorModule(catalogName, "io.trino.plugin.raptor.legacy", "trino.plugin.raptor.legacy"), new MBeanServerModule(), binder -> {
            binder.bind(NodeManager.class).toInstance((Object)context.getNodeManager());
            binder.bind(PageSorter.class).toInstance((Object)context.getPageSorter());
            binder.bind(TypeManager.class).toInstance((Object)context.getTypeManager());
        }, this.metadataModule, new BackupModule(this.backupProviders), new StorageModule(), new RaptorModule(), new RaptorSecurityModule()});
        Injector injector = app.doNotInitializeLogging().setRequiredConfigurationProperties(config).initialize();
        return (Connector)injector.getInstance(RaptorConnector.class);
    }
}

