/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.raptor.legacy.backup;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.util.Providers;
import io.airlift.bootstrap.LifeCycleManager;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConfigBinder;
import io.airlift.configuration.ConfigurationAwareModule;
import io.trino.plugin.base.CatalogName;
import io.trino.plugin.raptor.legacy.backup.BackupConfig;
import io.trino.plugin.raptor.legacy.backup.BackupService;
import io.trino.plugin.raptor.legacy.backup.BackupServiceManager;
import io.trino.plugin.raptor.legacy.backup.BackupStore;
import io.trino.plugin.raptor.legacy.backup.FileBackupModule;
import io.trino.plugin.raptor.legacy.backup.HttpBackupModule;
import io.trino.plugin.raptor.legacy.backup.ManagedBackupStore;
import io.trino.plugin.raptor.legacy.backup.TimeoutBackupStore;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Singleton;
import org.weakref.jmx.MBeanExporter;

public class BackupModule
extends AbstractConfigurationAwareModule {
    private final Map<String, Module> providers;

    public BackupModule(Map<String, Module> providers) {
        this.providers = ImmutableMap.builder().put((Object)"file", (Object)new FileBackupModule()).put((Object)"http", (Object)new HttpBackupModule()).putAll(providers).buildOrThrow();
    }

    protected void setup(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(BackupConfig.class);
        String provider = ((BackupConfig)this.buildConfigObject(BackupConfig.class)).getProvider();
        if (provider == null) {
            binder.bind(BackupStore.class).toProvider(Providers.of(null));
        } else {
            Module module = this.providers.get(provider);
            if (module == null) {
                binder.addError("Unknown backup provider: %s", new Object[]{provider});
            } else if (module instanceof ConfigurationAwareModule) {
                this.install(module);
            } else {
                binder.install(module);
            }
        }
        binder.bind(BackupService.class).to(BackupServiceManager.class).in(Scopes.SINGLETON);
    }

    @Provides
    @Singleton
    private static Optional<BackupStore> createBackupStore(@Nullable BackupStore store, LifeCycleManager lifeCycleManager, MBeanExporter exporter, CatalogName catalogName, BackupConfig config) {
        if (store == null) {
            return Optional.empty();
        }
        TimeoutBackupStore proxy = new TimeoutBackupStore(store, catalogName.toString(), config.getTimeout(), config.getTimeoutThreads());
        lifeCycleManager.addInstance((Object)proxy);
        ManagedBackupStore managed = new ManagedBackupStore(proxy);
        exporter.exportWithGeneratedName((Object)managed, BackupStore.class, catalogName.toString());
        return Optional.of(managed);
    }
}

