/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.raptor.legacy.backup;

import io.airlift.log.Logger;
import io.trino.plugin.raptor.legacy.backup.BackupOperationStats;
import io.trino.plugin.raptor.legacy.backup.BackupStore;
import java.io.File;
import java.util.Objects;
import java.util.UUID;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class ManagedBackupStore
implements BackupStore {
    private final BackupStore store;
    private final Logger log;
    private final BackupOperationStats backupShard = new BackupOperationStats();
    private final BackupOperationStats restoreShard = new BackupOperationStats();
    private final BackupOperationStats deleteShard = new BackupOperationStats();
    private final BackupOperationStats shardExists = new BackupOperationStats();

    public ManagedBackupStore(BackupStore store) {
        this.store = Objects.requireNonNull(store, "store is null");
        this.log = Logger.get(store.getClass());
    }

    @Override
    public void backupShard(UUID uuid, File source) {
        this.log.debug("Creating shard backup: %s", new Object[]{uuid});
        this.backupShard.run(() -> this.store.backupShard(uuid, source));
    }

    @Override
    public void restoreShard(UUID uuid, File target) {
        this.log.debug("Restoring shard backup: %s", new Object[]{uuid});
        this.restoreShard.run(() -> this.store.restoreShard(uuid, target));
    }

    @Override
    public boolean deleteShard(UUID uuid) {
        this.log.debug("Deleting shard backup: %s", new Object[]{uuid});
        return this.deleteShard.run(() -> this.store.deleteShard(uuid));
    }

    @Override
    public boolean shardExists(UUID uuid) {
        return this.shardExists.run(() -> this.store.shardExists(uuid));
    }

    @Managed
    @Nested
    public BackupOperationStats getBackupShard() {
        return this.backupShard;
    }

    @Managed
    @Nested
    public BackupOperationStats getRestoreShard() {
        return this.restoreShard;
    }

    @Managed
    @Nested
    public BackupOperationStats getDeleteShard() {
        return this.deleteShard;
    }

    @Managed
    @Nested
    public BackupOperationStats getShardExists() {
        return this.shardExists;
    }
}

