/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.raptor.legacy.metadata;

import com.google.common.base.Ticker;
import io.airlift.concurrent.Threads;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import io.trino.plugin.raptor.legacy.NodeSupplier;
import io.trino.plugin.raptor.legacy.RaptorErrorCode;
import io.trino.plugin.raptor.legacy.metadata.MetadataConfig;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Node;
import io.trino.spi.TrinoException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.concurrent.GuardedBy;
import javax.inject.Inject;

public class AssignmentLimiter {
    private static final Logger log = Logger.get(AssignmentLimiter.class);
    private final NodeSupplier nodeSupplier;
    private final Ticker ticker;
    private final Duration reassignmentDelay;
    private final Duration reassignmentInterval;
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1, Threads.daemonThreadsNamed((String)"assignment-limiter"));
    private final AtomicBoolean started = new AtomicBoolean();
    @GuardedBy(value="this")
    private final Map<String, Long> delayedNodes = new HashMap<String, Long>();
    @GuardedBy(value="this")
    private final Set<String> offlineNodes = new HashSet<String>();
    @GuardedBy(value="this")
    private OptionalLong lastOfflined = OptionalLong.empty();

    @Inject
    public AssignmentLimiter(NodeSupplier nodeSupplier, Ticker ticker, MetadataConfig config) {
        this(nodeSupplier, ticker, config.getReassignmentDelay(), config.getReassignmentInterval());
    }

    public AssignmentLimiter(NodeSupplier nodeSupplier, Ticker ticker, Duration reassignmentDelay, Duration reassignmentInterval) {
        this.nodeSupplier = Objects.requireNonNull(nodeSupplier, "nodeSupplier is null");
        this.ticker = Objects.requireNonNull(ticker, "ticker is null");
        this.reassignmentDelay = Objects.requireNonNull(reassignmentDelay, "reassignmentDelay is null");
        this.reassignmentInterval = Objects.requireNonNull(reassignmentInterval, "reassignmentInterval is null");
    }

    @PostConstruct
    public void start() {
        if (!this.started.getAndSet(true)) {
            this.scheduler.scheduleWithFixedDelay(() -> {
                try {
                    this.clearOnlineNodes();
                }
                catch (Throwable t) {
                    log.error(t, "Error clearing online nodes");
                }
            }, 2L, 2L, TimeUnit.SECONDS);
        }
    }

    @PreDestroy
    public void shutdown() {
        this.scheduler.shutdownNow();
    }

    public synchronized void checkAssignFrom(String nodeIdentifier) {
        long start;
        if (this.offlineNodes.contains(nodeIdentifier)) {
            return;
        }
        long now = this.ticker.read();
        Duration delay = new Duration((double)(now - (start = this.delayedNodes.computeIfAbsent(nodeIdentifier, key -> now).longValue())), TimeUnit.NANOSECONDS);
        if (delay.compareTo(this.reassignmentDelay) < 0) {
            throw new TrinoException((ErrorCodeSupplier)RaptorErrorCode.RAPTOR_REASSIGNMENT_DELAY, String.format("Reassignment delay is in effect for node %s (elapsed: %s)", nodeIdentifier, delay.convertToMostSuccinctTimeUnit()));
        }
        if (this.lastOfflined.isPresent() && (delay = new Duration((double)(now - this.lastOfflined.getAsLong()), TimeUnit.NANOSECONDS)).compareTo(this.reassignmentInterval) < 0) {
            throw new TrinoException((ErrorCodeSupplier)RaptorErrorCode.RAPTOR_REASSIGNMENT_THROTTLE, String.format("Reassignment throttle is in effect for node %s (elapsed: %s)", nodeIdentifier, delay.convertToMostSuccinctTimeUnit()));
        }
        this.delayedNodes.remove(nodeIdentifier);
        this.offlineNodes.add(nodeIdentifier);
        this.lastOfflined = OptionalLong.of(now);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearOnlineNodes() {
        Set onlineNodes = this.nodeSupplier.getWorkerNodes().stream().map(Node::getNodeIdentifier).collect(Collectors.toSet());
        AssignmentLimiter assignmentLimiter = this;
        synchronized (assignmentLimiter) {
            this.delayedNodes.keySet().removeAll(onlineNodes);
            this.offlineNodes.removeAll(onlineNodes);
        }
    }
}

