/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.raptor.legacy.metadata;

import com.google.common.base.Preconditions;
import java.util.Objects;

public class BucketNode {
    private final int bucketNumber;
    private final String nodeIdentifier;

    public BucketNode(int bucketNumber, String nodeIdentifier) {
        Preconditions.checkArgument((bucketNumber >= 0 ? 1 : 0) != 0, (Object)"bucket number must be positive");
        this.bucketNumber = bucketNumber;
        this.nodeIdentifier = Objects.requireNonNull(nodeIdentifier, "nodeIdentifier is null");
    }

    public int getBucketNumber() {
        return this.bucketNumber;
    }

    public String getNodeIdentifier() {
        return this.nodeIdentifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BucketNode that = (BucketNode)o;
        return this.bucketNumber == that.bucketNumber && Objects.equals(this.nodeIdentifier, that.nodeIdentifier);
    }

    public int hashCode() {
        return Objects.hash(this.bucketNumber, this.nodeIdentifier);
    }

    public String toString() {
        return this.bucketNumber + ":" + this.nodeIdentifier;
    }
}

