/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.raptor.legacy.metadata;

import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeParameter;
import com.google.common.reflect.TypeToken;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConditionalModule;
import io.airlift.configuration.ConfigBinder;
import io.airlift.dbpool.H2EmbeddedDataSourceModule;
import io.airlift.dbpool.MySqlDataSource;
import io.airlift.dbpool.MySqlDataSourceConfig;
import io.airlift.discovery.client.ServiceDescriptor;
import io.airlift.discovery.client.ServiceSelector;
import io.airlift.discovery.client.testing.StaticServiceSelector;
import io.trino.plugin.raptor.legacy.metadata.DatabaseConfig;
import io.trino.plugin.raptor.legacy.metadata.ForMetadata;
import io.trino.plugin.raptor.legacy.metadata.H2ShardDao;
import io.trino.plugin.raptor.legacy.metadata.JdbcDatabaseConfig;
import io.trino.plugin.raptor.legacy.metadata.MySqlShardDao;
import io.trino.plugin.raptor.legacy.metadata.ShardDao;
import io.trino.plugin.raptor.legacy.util.DaoSupplier;
import java.lang.reflect.Type;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.sql.DataSource;
import org.jdbi.v3.core.ConnectionFactory;
import org.jdbi.v3.core.Jdbi;

public class DatabaseMetadataModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder ignored) {
        this.install(ConditionalModule.conditionalModule(DatabaseConfig.class, config -> "mysql".equals(config.getDatabaseType()), binder -> {
            binder.install((Module)new MySqlDataSourceModule());
            DatabaseMetadataModule.bindDaoSupplier(binder, ShardDao.class, MySqlShardDao.class);
        }));
        this.install(ConditionalModule.conditionalModule(DatabaseConfig.class, config -> "h2".equals(config.getDatabaseType()), binder -> {
            binder.install((Module)new H2EmbeddedDataSourceModule("metadata", ForMetadata.class, new Class[0]));
            DatabaseMetadataModule.bindDaoSupplier(binder, ShardDao.class, H2ShardDao.class);
        }));
    }

    @ForMetadata
    @Singleton
    @Provides
    public ConnectionFactory createConnectionFactory(@ForMetadata DataSource dataSource) {
        return dataSource::getConnection;
    }

    public static <B, T extends B> void bindDaoSupplier(Binder binder, Class<B> baseType, Class<T> type) {
        binder.bind(DatabaseMetadataModule.daoSupplierTypeToken(baseType)).toProvider(new DaoSupplierProvider<T>(type)).in(Scopes.SINGLETON);
    }

    private static <T> TypeLiteral<DaoSupplier<? extends T>> daoSupplierTypeToken(Class<T> type) {
        Type javaType = new TypeToken<DaoSupplier<T>>(){}.where(new TypeParameter<T>(){}, TypeToken.of(type)).getType();
        return TypeLiteral.get((Type)javaType);
    }

    private static class MySqlDataSourceModule
    implements Module {
        private MySqlDataSourceModule() {
        }

        public void configure(Binder binder) {
            ConfigBinder.configBinder((Binder)binder).bindConfig(JdbcDatabaseConfig.class);
            ConfigBinder.configBinder((Binder)binder).bindConfig(MySqlDataSourceConfig.class, ForMetadata.class, "metadata");
            ConfigBinder.configBinder((Binder)binder).bindConfigDefaults(MySqlDataSourceConfig.class, ForMetadata.class, config -> {
                config.setMaxConnections(100);
                config.setDefaultFetchSize(1000);
            });
        }

        @ForMetadata
        @Singleton
        @Provides
        DataSource createDataSource(JdbcDatabaseConfig config, @ForMetadata MySqlDataSourceConfig mysqlConfig) {
            ServiceDescriptor descriptor = ServiceDescriptor.serviceDescriptor((String)"mysql").addProperty("jdbc", config.getUrl()).build();
            return new MySqlDataSource((ServiceSelector)new StaticServiceSelector(new ServiceDescriptor[]{descriptor}), mysqlConfig);
        }
    }

    private static class DaoSupplierProvider<T>
    implements Provider<DaoSupplier<T>> {
        private final Class<T> type;
        private Injector injector;

        public DaoSupplierProvider(Class<T> type) {
            this.type = Objects.requireNonNull(type, "type is null");
        }

        @Inject
        public void setInjector(Injector injector) {
            this.injector = injector;
        }

        public DaoSupplier<T> get() {
            Preconditions.checkState((this.injector != null ? 1 : 0) != 0, (Object)"injector was not set");
            Jdbi dbi = (Jdbi)this.injector.getInstance(Key.get(Jdbi.class, ForMetadata.class));
            return new DaoSupplier(dbi, this.type);
        }
    }
}

