/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.raptor.legacy.security;

import com.google.inject.Binder;
import com.google.inject.Module;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConditionalModule;
import io.trino.plugin.base.security.ConnectorAccessControlModule;
import io.trino.plugin.base.security.FileBasedAccessControlModule;
import io.trino.plugin.base.security.ReadOnlySecurityModule;
import io.trino.plugin.raptor.legacy.security.RaptorSecurity;
import io.trino.plugin.raptor.legacy.security.RaptorSecurityConfig;

public class RaptorSecurityModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        this.install((Module)new ConnectorAccessControlModule());
        this.bindSecurityModule(RaptorSecurity.READ_ONLY, (Module)new ReadOnlySecurityModule());
        this.bindSecurityModule(RaptorSecurity.FILE, (Module)new FileBasedAccessControlModule());
    }

    private void bindSecurityModule(RaptorSecurity raptorSecurity, Module module) {
        this.install(ConditionalModule.conditionalModule(RaptorSecurityConfig.class, security -> raptorSecurity.equals((Object)security.getSecuritySystem()), (Module)module));
    }
}

