/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.raptor.legacy.storage;

import io.airlift.log.Logger;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.orc.OrcStruct;
import org.apache.hadoop.hive.ql.io.orc.OrcUtil;
import org.apache.hadoop.hive.ql.io.orc.RecordReader;
import org.apache.hadoop.hive.ql.io.orc.Writer;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;

public final class OrcFileRewriter {
    private static final Logger log = Logger.get(OrcFileRewriter.class);
    private static final Configuration CONFIGURATION = new Configuration(false);

    private OrcFileRewriter() {
    }

    /*
     * Exception decompiling
     */
    public static OrcFileInfo rewrite(File input, File output, BitSet rowsToDelete) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static OrcFileInfo rewrite(RecordReader reader, Writer writer, BitSet rowsToDelete, int inputRowCount) throws IOException {
        Object object = null;
        int row = 0;
        long rowCount = 0L;
        long uncompressedSize = 0L;
        if ((row = rowsToDelete.nextClearBit(row)) < inputRowCount) {
            reader.seekToRow((long)row);
        }
        while (row < inputRowCount) {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedIOException();
            }
            if (reader.getRowNumber() < (long)row) {
                reader.next(object);
                continue;
            }
            object = reader.next(object);
            writer.addRow(object);
            ++rowCount;
            uncompressedSize += (long)OrcFileRewriter.uncompressedSize(object);
            row = rowsToDelete.nextClearBit(row + 1);
        }
        return new OrcFileInfo(rowCount, uncompressedSize);
    }

    private static Path path(File input) {
        return new Path(input.toURI());
    }

    private static int uncompressedSize(Object object) throws IOException {
        if (object instanceof OrcStruct) {
            OrcStruct struct = (OrcStruct)object;
            int size = 0;
            for (int i = 0; i < struct.getNumFields(); ++i) {
                size += OrcFileRewriter.uncompressedSize(OrcUtil.getFieldValue((OrcStruct)struct, (int)i));
            }
            return size;
        }
        if (object == null || object instanceof BooleanWritable) {
            return 1;
        }
        if (object instanceof LongWritable) {
            return 8;
        }
        if (object instanceof DoubleWritable) {
            return 8;
        }
        if (object instanceof HiveDecimalWritable) {
            return 8;
        }
        if (object instanceof Text) {
            return ((Text)object).getLength();
        }
        if (object instanceof BytesWritable) {
            return ((BytesWritable)object).getLength();
        }
        if (object instanceof List) {
            int size = 0;
            for (Object element : (Iterable)object) {
                size += OrcFileRewriter.uncompressedSize(element);
            }
            return size;
        }
        if (object instanceof Map) {
            int size = 0;
            for (Map.Entry entry : ((Map)object).entrySet()) {
                size += OrcFileRewriter.uncompressedSize(entry.getKey());
                size += OrcFileRewriter.uncompressedSize(entry.getValue());
            }
            return size;
        }
        throw new IOException("Unhandled ORC object: " + object.getClass().getName());
    }

    public static class OrcFileInfo {
        private final long rowCount;
        private final long uncompressedSize;

        public OrcFileInfo(long rowCount, long uncompressedSize) {
            this.rowCount = rowCount;
            this.uncompressedSize = uncompressedSize;
        }

        public long getRowCount() {
            return this.rowCount;
        }

        public long getUncompressedSize() {
            return this.uncompressedSize;
        }
    }
}

