/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.raptor.legacy.storage;

import com.google.common.base.Ticker;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Scopes;
import io.airlift.configuration.ConfigBinder;
import io.trino.plugin.raptor.legacy.backup.BackupManager;
import io.trino.plugin.raptor.legacy.metadata.AssignmentLimiter;
import io.trino.plugin.raptor.legacy.metadata.DatabaseShardManager;
import io.trino.plugin.raptor.legacy.metadata.DatabaseShardRecorder;
import io.trino.plugin.raptor.legacy.metadata.MetadataConfig;
import io.trino.plugin.raptor.legacy.metadata.ShardCleaner;
import io.trino.plugin.raptor.legacy.metadata.ShardCleanerConfig;
import io.trino.plugin.raptor.legacy.metadata.ShardManager;
import io.trino.plugin.raptor.legacy.metadata.ShardRecorder;
import io.trino.plugin.raptor.legacy.storage.BucketBalancer;
import io.trino.plugin.raptor.legacy.storage.BucketBalancerConfig;
import io.trino.plugin.raptor.legacy.storage.FileStorageService;
import io.trino.plugin.raptor.legacy.storage.RaptorStorageManager;
import io.trino.plugin.raptor.legacy.storage.ShardEjector;
import io.trino.plugin.raptor.legacy.storage.ShardRecoveryManager;
import io.trino.plugin.raptor.legacy.storage.StorageManager;
import io.trino.plugin.raptor.legacy.storage.StorageManagerConfig;
import io.trino.plugin.raptor.legacy.storage.StorageService;
import io.trino.plugin.raptor.legacy.storage.organization.JobFactory;
import io.trino.plugin.raptor.legacy.storage.organization.OrganizationJobFactory;
import io.trino.plugin.raptor.legacy.storage.organization.ShardCompactionManager;
import io.trino.plugin.raptor.legacy.storage.organization.ShardCompactor;
import io.trino.plugin.raptor.legacy.storage.organization.ShardOrganizationManager;
import io.trino.plugin.raptor.legacy.storage.organization.ShardOrganizer;
import org.weakref.jmx.guice.ExportBinder;

public class StorageModule
implements Module {
    public void configure(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(StorageManagerConfig.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(BucketBalancerConfig.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(ShardCleanerConfig.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(MetadataConfig.class);
        binder.bind(Ticker.class).toInstance((Object)Ticker.systemTicker());
        binder.bind(StorageManager.class).to(RaptorStorageManager.class).in(Scopes.SINGLETON);
        binder.bind(StorageService.class).to(FileStorageService.class).in(Scopes.SINGLETON);
        binder.bind(ShardManager.class).to(DatabaseShardManager.class).in(Scopes.SINGLETON);
        binder.bind(ShardRecorder.class).to(DatabaseShardRecorder.class).in(Scopes.SINGLETON);
        binder.bind(DatabaseShardManager.class).in(Scopes.SINGLETON);
        binder.bind(DatabaseShardRecorder.class).in(Scopes.SINGLETON);
        binder.bind(ShardRecoveryManager.class).in(Scopes.SINGLETON);
        binder.bind(BackupManager.class).in(Scopes.SINGLETON);
        binder.bind(ShardCompactionManager.class).in(Scopes.SINGLETON);
        binder.bind(ShardOrganizationManager.class).in(Scopes.SINGLETON);
        binder.bind(ShardOrganizer.class).in(Scopes.SINGLETON);
        binder.bind(JobFactory.class).to(OrganizationJobFactory.class).in(Scopes.SINGLETON);
        binder.bind(ShardCompactor.class).in(Scopes.SINGLETON);
        binder.bind(ShardEjector.class).in(Scopes.SINGLETON);
        binder.bind(ShardCleaner.class).in(Scopes.SINGLETON);
        binder.bind(BucketBalancer.class).in(Scopes.SINGLETON);
        binder.bind(AssignmentLimiter.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(ShardRecoveryManager.class).withGeneratedName();
        ExportBinder.newExporter((Binder)binder).export(BackupManager.class).withGeneratedName();
        ExportBinder.newExporter((Binder)binder).export(StorageManager.class).as(generator -> generator.generatedNameOf(RaptorStorageManager.class));
        ExportBinder.newExporter((Binder)binder).export(ShardCompactionManager.class).withGeneratedName();
        ExportBinder.newExporter((Binder)binder).export(ShardOrganizer.class).withGeneratedName();
        ExportBinder.newExporter((Binder)binder).export(ShardCompactor.class).withGeneratedName();
        ExportBinder.newExporter((Binder)binder).export(ShardEjector.class).withGeneratedName();
        ExportBinder.newExporter((Binder)binder).export(ShardCleaner.class).withGeneratedName();
        ExportBinder.newExporter((Binder)binder).export(BucketBalancer.class).withGeneratedName();
        ExportBinder.newExporter((Binder)binder).export(JobFactory.class).withGeneratedName();
    }
}

