/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.raptor.legacy.storage.organization;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.airlift.concurrent.MoreFutures;
import io.airlift.concurrent.Threads;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import io.trino.plugin.raptor.legacy.metadata.ForMetadata;
import io.trino.plugin.raptor.legacy.metadata.MetadataDao;
import io.trino.plugin.raptor.legacy.metadata.ShardManager;
import io.trino.plugin.raptor.legacy.metadata.ShardMetadata;
import io.trino.plugin.raptor.legacy.metadata.Table;
import io.trino.plugin.raptor.legacy.storage.StorageManagerConfig;
import io.trino.plugin.raptor.legacy.storage.organization.OrganizationSet;
import io.trino.plugin.raptor.legacy.storage.organization.ShardIndexInfo;
import io.trino.plugin.raptor.legacy.storage.organization.ShardOrganizer;
import io.trino.plugin.raptor.legacy.storage.organization.ShardOrganizerDao;
import io.trino.plugin.raptor.legacy.storage.organization.ShardOrganizerUtil;
import io.trino.plugin.raptor.legacy.storage.organization.ShardRange;
import io.trino.plugin.raptor.legacy.storage.organization.TableOrganizationInfo;
import io.trino.plugin.raptor.legacy.util.DatabaseUtil;
import io.trino.spi.NodeManager;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.jdbi.v3.core.Jdbi;

public class ShardOrganizationManager {
    private static final Logger log = Logger.get(ShardOrganizationManager.class);
    private final ScheduledExecutorService discoveryService = Executors.newScheduledThreadPool(1, Threads.daemonThreadsNamed((String)"shard-organization-discovery"));
    private final AtomicBoolean started = new AtomicBoolean();
    private final Jdbi dbi;
    private final MetadataDao metadataDao;
    private final ShardOrganizerDao organizerDao;
    private final ShardManager shardManager;
    private final boolean enabled;
    private final long organizationIntervalMillis;
    private final long organizationDiscoveryIntervalMillis;
    private final String currentNodeIdentifier;
    private final ShardOrganizer organizer;
    private final Set<Long> tablesInProgress = Sets.newConcurrentHashSet();

    @Inject
    public ShardOrganizationManager(@ForMetadata Jdbi dbi, NodeManager nodeManager, ShardManager shardManager, ShardOrganizer organizer, StorageManagerConfig config) {
        this(dbi, nodeManager.getCurrentNode().getNodeIdentifier(), shardManager, organizer, config.isOrganizationEnabled(), config.getOrganizationInterval(), config.getOrganizationDiscoveryInterval());
    }

    public ShardOrganizationManager(Jdbi dbi, String currentNodeIdentifier, ShardManager shardManager, ShardOrganizer organizer, boolean enabled, Duration organizationInterval, Duration organizationDiscoveryInterval) {
        this.dbi = Objects.requireNonNull(dbi, "dbi is null");
        this.metadataDao = DatabaseUtil.onDemandDao(dbi, MetadataDao.class);
        this.organizerDao = DatabaseUtil.onDemandDao(dbi, ShardOrganizerDao.class);
        this.organizer = Objects.requireNonNull(organizer, "organizer is null");
        this.shardManager = Objects.requireNonNull(shardManager, "shardManager is null");
        this.currentNodeIdentifier = Objects.requireNonNull(currentNodeIdentifier, "currentNodeIdentifier is null");
        this.enabled = enabled;
        Objects.requireNonNull(organizationInterval, "organizationInterval is null");
        this.organizationIntervalMillis = Math.max(1L, organizationInterval.roundTo(TimeUnit.MILLISECONDS));
        this.organizationDiscoveryIntervalMillis = Math.max(1L, organizationDiscoveryInterval.roundTo(TimeUnit.MILLISECONDS));
    }

    @PostConstruct
    public void start() {
        if (!this.enabled || this.started.getAndSet(true)) {
            return;
        }
        this.startDiscovery();
    }

    @PreDestroy
    public void shutdown() {
        this.discoveryService.shutdownNow();
    }

    private void startDiscovery() {
        this.discoveryService.scheduleWithFixedDelay(() -> {
            try {
                TimeUnit.SECONDS.sleep(ThreadLocalRandom.current().nextLong(1L, this.organizationDiscoveryIntervalMillis));
                log.info("Running shard organizer...");
                this.submitJobs(this.discoverAndInitializeTablesToOrganize());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Throwable t) {
                log.error(t, "Error running shard organizer");
            }
        }, 0L, this.organizationDiscoveryIntervalMillis, TimeUnit.MILLISECONDS);
    }

    @VisibleForTesting
    Set<Long> discoverAndInitializeTablesToOrganize() {
        Set<Long> enabledTableIds = this.metadataDao.getOrganizationEligibleTables();
        Set<TableOrganizationInfo> tableOrganizationInfo = this.organizerDao.getNodeTableOrganizationInfo(this.currentNodeIdentifier);
        ImmutableMap organizationInfos = Maps.uniqueIndex(tableOrganizationInfo, TableOrganizationInfo::getTableId);
        Sets.difference(enabledTableIds, organizationInfos.keySet()).forEach(tableId -> this.organizerDao.insertNode(this.currentNodeIdentifier, (long)tableId));
        ImmutableSet.Builder tableIds = ImmutableSet.builder();
        for (Long tableId2 : enabledTableIds) {
            TableOrganizationInfo info = (TableOrganizationInfo)organizationInfos.get(tableId2);
            if (info != null && !this.shouldRunOrganization(info)) continue;
            tableIds.add((Object)tableId2);
        }
        return tableIds.build();
    }

    private void submitJobs(Set<Long> tableIds) {
        tableIds.forEach(this::runOrganization);
    }

    private void runOrganization(long tableId) {
        Set<ShardMetadata> filteredShards;
        Collection<ShardIndexInfo> indexInfos;
        Set<ShardMetadata> shardMetadatas = this.shardManager.getNodeShards(this.currentNodeIdentifier, tableId);
        Table tableInfo = this.metadataDao.getTableInformation(tableId);
        Set<OrganizationSet> organizationSets = ShardOrganizationManager.createOrganizationSets(tableInfo, indexInfos = ShardOrganizerUtil.getOrganizationEligibleShards(this.dbi, this.metadataDao, tableInfo, filteredShards = shardMetadatas.stream().filter(shard -> !this.organizer.inProgress(shard.getShardUuid())).collect(Collectors.toSet()), true));
        if (organizationSets.isEmpty()) {
            return;
        }
        log.info("Created %s organization set(s) from %s shards for table ID %s", new Object[]{organizationSets.size(), filteredShards.size(), tableId});
        long lastStartTime = System.currentTimeMillis();
        this.tablesInProgress.add(tableId);
        ImmutableList.Builder futures = ImmutableList.builder();
        for (OrganizationSet organizationSet : organizationSets) {
            futures.add(this.organizer.enqueue(organizationSet));
        }
        MoreFutures.allAsList((List)futures.build()).whenComplete((value, throwable) -> {
            this.tablesInProgress.remove(tableId);
            this.organizerDao.updateLastStartTime(this.currentNodeIdentifier, tableId, lastStartTime);
        });
    }

    private boolean shouldRunOrganization(TableOrganizationInfo info) {
        if (this.tablesInProgress.contains(info.getTableId())) {
            return false;
        }
        if (info.getLastStartTimeMillis().isEmpty()) {
            return true;
        }
        return System.currentTimeMillis() - info.getLastStartTimeMillis().getAsLong() >= this.organizationIntervalMillis;
    }

    @VisibleForTesting
    static Set<OrganizationSet> createOrganizationSets(Table tableInfo, Collection<ShardIndexInfo> shards) {
        return ShardOrganizerUtil.getShardsByDaysBuckets(tableInfo, shards).stream().map(indexInfos -> ShardOrganizationManager.getOverlappingOrganizationSets(tableInfo, indexInfos)).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private static Set<OrganizationSet> getOverlappingOrganizationSets(Table tableInfo, Collection<ShardIndexInfo> shards) {
        if (shards.size() <= 1) {
            return ImmutableSet.of();
        }
        List sortedShards = shards.stream().sorted((o1, o2) -> {
            ShardRange sortRange1 = o1.getSortRange().get();
            ShardRange sortRange2 = o2.getSortRange().get();
            return ComparisonChain.start().compare((Comparable)sortRange1.getMinTuple(), (Comparable)sortRange2.getMinTuple()).compare((Comparable)sortRange2.getMaxTuple(), (Comparable)sortRange1.getMaxTuple()).result();
        }).collect(Collectors.toList());
        HashSet<OrganizationSet> organizationSets = new HashSet<OrganizationSet>();
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)((ShardIndexInfo)sortedShards.get(0)));
        int previousRange = 0;
        for (int nextRange = previousRange + 1; nextRange < sortedShards.size(); ++nextRange) {
            ShardRange sortRange2;
            ShardRange sortRange1 = ((ShardIndexInfo)sortedShards.get(previousRange)).getSortRange().get();
            if (sortRange1.overlaps(sortRange2 = ((ShardIndexInfo)sortedShards.get(nextRange)).getSortRange().get()) && !sortRange1.adjacent(sortRange2)) {
                builder.add((Object)((ShardIndexInfo)sortedShards.get(nextRange)));
                if (sortRange1.encloses(sortRange2)) continue;
                previousRange = nextRange;
                continue;
            }
            ImmutableSet indexInfos = builder.build();
            if (indexInfos.size() > 1) {
                organizationSets.add(ShardOrganizerUtil.createOrganizationSet(tableInfo.getTableId(), (Set<ShardIndexInfo>)indexInfos));
            }
            builder = ImmutableSet.builder();
            previousRange = nextRange;
            builder.add((Object)((ShardIndexInfo)sortedShards.get(previousRange)));
        }
        ImmutableSet indexInfos = builder.build();
        if (indexInfos.size() > 1) {
            organizationSets.add(ShardOrganizerUtil.createOrganizationSet(tableInfo.getTableId(), (Set<ShardIndexInfo>)indexInfos));
        }
        return organizationSets;
    }
}

