/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.raptor.legacy.storage.organization;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import io.trino.plugin.raptor.legacy.storage.organization.ShardRange;
import io.trino.plugin.raptor.legacy.storage.organization.Tuple;
import io.trino.spi.block.Block;
import io.trino.spi.type.DateType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.Type;
import java.time.Duration;

public final class TemporalFunction {
    private TemporalFunction() {
    }

    public static int getDay(Type type, Block block, int position) {
        if (type.equals(DateType.DATE)) {
            return Math.toIntExact(DateType.DATE.getLong(block, position));
        }
        if (type.equals(TimestampType.TIMESTAMP_MILLIS)) {
            long days = Math.floorDiv(TimestampType.TIMESTAMP_MILLIS.getLong(block, position), 86400000000L);
            return Math.toIntExact(days);
        }
        throw new IllegalArgumentException("Wrong type for temporal column: " + type);
    }

    public static int getDayFromRange(ShardRange range) {
        Tuple min = range.getMinTuple();
        Tuple max = range.getMaxTuple();
        Preconditions.checkArgument((boolean)((Type)Iterables.getOnlyElement(min.getTypes())).equals(Iterables.getOnlyElement(max.getTypes())), (Object)"type of min and max is not same");
        Type type = (Type)Iterables.getOnlyElement(min.getTypes());
        if (type.equals(DateType.DATE)) {
            return (Integer)Iterables.getOnlyElement(min.getValues());
        }
        if (type.equals(TimestampType.TIMESTAMP_MILLIS)) {
            long minValue = (Long)Iterables.getOnlyElement(min.getValues());
            long maxValue = (Long)Iterables.getOnlyElement(max.getValues());
            return TemporalFunction.determineDay(minValue, maxValue);
        }
        throw new IllegalArgumentException("Wrong type for shard range: " + type);
    }

    private static int determineDay(long rangeStart, long rangeEnd) {
        long millisInEndDay;
        int endDay;
        int startDay = Math.toIntExact(Duration.ofMillis(rangeStart).toDays());
        if (startDay == (endDay = Math.toIntExact(Duration.ofMillis(rangeEnd).toDays()))) {
            return startDay;
        }
        if (endDay - startDay > 1) {
            return startDay + 1;
        }
        long millisInStartDay = Duration.ofDays(endDay).toMillis() - rangeStart;
        return millisInStartDay >= (millisInEndDay = rangeEnd - Duration.ofDays(endDay).toMillis()) ? startDay : endDay;
    }
}

