/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.multilang;

import com.amazonaws.services.kinesis.clientlibrary.interfaces.IRecordProcessorFactory;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.KinesisClientLibConfiguration;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.Worker;
import com.amazonaws.services.kinesis.multilang.MultiLangDaemonConfig;
import com.amazonaws.services.kinesis.multilang.MultiLangRecordProcessorFactory;
import java.io.IOException;
import java.io.PrintStream;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MultiLangDaemon
implements Callable<Integer> {
    private static final Log LOG = LogFactory.getLog(MultiLangDaemon.class);
    private Worker worker;

    public MultiLangDaemon(KinesisClientLibConfiguration configuration, MultiLangRecordProcessorFactory recordProcessorFactory, ExecutorService workerThreadPool) {
        this(new Worker((IRecordProcessorFactory)recordProcessorFactory, configuration, workerThreadPool));
    }

    public MultiLangDaemon(Worker worker) {
        this.worker = worker;
    }

    public static void printUsage(PrintStream stream, String messageToPrepend) {
        StringBuilder builder = new StringBuilder();
        if (messageToPrepend != null) {
            builder.append(messageToPrepend);
        }
        builder.append(String.format("java %s <properties file>", MultiLangDaemon.class.getCanonicalName()));
        stream.println(builder.toString());
    }

    @Override
    public Integer call() throws Exception {
        int exitCode = 0;
        try {
            this.worker.run();
        }
        catch (Throwable t) {
            LOG.error((Object)"Caught throwable while processing data.", t);
            exitCode = 1;
        }
        return exitCode;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            MultiLangDaemon.printUsage(System.err, "You must provide a properties file");
            System.exit(1);
        }
        MultiLangDaemonConfig config = null;
        try {
            config = new MultiLangDaemonConfig(args[0]);
        }
        catch (IOException e) {
            MultiLangDaemon.printUsage(System.err, "You must provide a properties file");
            System.exit(1);
        }
        catch (IllegalArgumentException e) {
            MultiLangDaemon.printUsage(System.err, e.getMessage());
            System.exit(1);
        }
        ExecutorService executorService = config.getExecutorService();
        MultiLangDaemon daemon = new MultiLangDaemon(config.getKinesisClientLibConfiguration(), config.getRecordProcessorFactory(), executorService);
        Future<Integer> future = executorService.submit(daemon);
        try {
            System.exit(future.get());
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.error((Object)"Encountered an error while running daemon", (Throwable)e);
        }
        System.exit(1);
    }
}

