/*
 * Decompiled with CFR 0.152.
 */
package com.qubole.rubix.bookkeeper;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.google.shaded.shaded.common.annotations.VisibleForTesting;
import com.google.shaded.shaded.common.base.Preconditions;
import com.google.shaded.shaded.common.base.Ticker;
import com.google.shaded.shaded.common.cache.Cache;
import com.google.shaded.shaded.common.cache.CacheBuilder;
import com.google.shaded.shaded.common.cache.CacheLoader;
import com.google.shaded.shaded.common.cache.LoadingCache;
import com.google.shaded.shaded.common.cache.RemovalListener;
import com.google.shaded.shaded.common.cache.RemovalNotification;
import com.google.shaded.shaded.common.collect.ImmutableMap;
import com.google.shaded.shaded.common.hash.BloomFilter;
import com.google.shaded.shaded.common.hash.Funnels;
import com.google.shaded.shaded.common.util.concurrent.Service;
import com.qubole.rubix.bookkeeper.FileMetadata;
import com.qubole.rubix.bookkeeper.RemoteFetchProcessor;
import com.qubole.rubix.bookkeeper.ThrowingEmptyCache;
import com.qubole.rubix.bookkeeper.utils.DiskUtils;
import com.qubole.rubix.common.metrics.BookKeeperMetrics;
import com.qubole.rubix.core.CachingFileSystemStatsProvider;
import com.qubole.rubix.core.ClusterManagerInitilizationException;
import com.qubole.rubix.core.ReadRequest;
import com.qubole.rubix.core.ReadRequestChainStats;
import com.qubole.rubix.core.RemoteReadRequestChain;
import com.qubole.rubix.spi.BookKeeperFactory;
import com.qubole.rubix.spi.CacheConfig;
import com.qubole.rubix.spi.CacheUtil;
import com.qubole.rubix.spi.ClusterManager;
import com.qubole.rubix.spi.ClusterType;
import com.qubole.rubix.spi.thrift.BlockLocation;
import com.qubole.rubix.spi.thrift.BookKeeperService;
import com.qubole.rubix.spi.thrift.CacheStatusRequest;
import com.qubole.rubix.spi.thrift.CacheStatusResponse;
import com.qubole.rubix.spi.thrift.FileInfo;
import com.qubole.rubix.spi.thrift.Location;
import com.qubole.rubix.spi.thrift.ReadResponse;
import com.qubole.rubix.spi.utils.DataSizeUnits;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.DirectBufferPool;
import org.apache.thrift.shaded.TException;

public abstract class BookKeeper
implements BookKeeperService.Iface {
    private static final int MAX_FILES_EXPECTED = 1000000;
    private static final double FILE_ACCESSED_FILTER_FPP = 0.01;
    private static Log log = LogFactory.getLog(BookKeeper.class);
    private static DirectBufferPool bufferPool = new DirectBufferPool();
    private static final CachingFileSystemStatsProvider warmupStats = new CachingFileSystemStatsProvider();
    protected static Cache<String, FileMetadata> fileMetadataCache;
    private static LoadingCache<String, FileInfo> fileInfoCache;
    protected volatile ClusterManager clusterManager;
    protected final Configuration conf;
    private static Integer lock;
    private long splitSize;
    private RemoteFetchProcessor fetchProcessor;
    private final Ticker ticker;
    private static long totalAvailableForCacheInMB;
    protected final MetricRegistry metrics;
    private final BookKeeperMetrics bookKeeperMetrics;
    private static Counter cacheEvictionCount;
    private static Counter cacheInvalidationCount;
    private static Counter cacheExpiryCount;
    private Counter totalRequestCount;
    private Counter remoteRequestCount;
    private Counter cacheRequestCount;
    private Counter nonlocalRequestCount;
    private Cache<String, Integer> generationNumberCache;
    private BloomFilter fileAccessedBloomFilter;

    public BookKeeper(Configuration conf, BookKeeperMetrics bookKeeperMetrics) throws FileNotFoundException {
        this(conf, bookKeeperMetrics, Ticker.systemTicker());
    }

    @Override
    public boolean isBookKeeperAlive() {
        return true;
    }

    @VisibleForTesting
    BookKeeper(Configuration conf, BookKeeperMetrics bookKeeperMetrics, Ticker ticker) throws FileNotFoundException {
        this.conf = conf;
        this.bookKeeperMetrics = bookKeeperMetrics;
        this.metrics = bookKeeperMetrics.getMetricsRegistry();
        this.ticker = ticker;
        this.splitSize = CacheConfig.getCacheFileSplitSize(conf);
        this.cleanupOldCacheFiles(conf);
        this.initializeMetrics();
        this.initializeCache(conf, ticker);
        this.fetchProcessor = null;
        if (CacheConfig.isParallelWarmupEnabled(conf)) {
            this.fetchProcessor = new RemoteFetchProcessor(this, this.metrics, conf, warmupStats);
        }
    }

    RemoteFetchProcessor getRemoteFetchProcessorInstance() {
        return this.fetchProcessor;
    }

    private void cleanupOldCacheFiles(Configuration conf) {
        if (CacheConfig.isCleanupFilesDuringStartEnabled(conf)) {
            try {
                int numDisks = CacheConfig.getCacheMaxDisks(conf);
                String dirSuffix = CacheConfig.getCacheDataDirSuffix(conf);
                List<String> dirPrefixList = CacheUtil.getDirPrefixList(conf);
                for (String dirPrefix : dirPrefixList) {
                    for (int i = 0; i < numDisks; ++i) {
                        java.nio.file.Path path = Paths.get(dirPrefix + i, dirSuffix, "*");
                        DiskUtils.clearDirectory(path.toString());
                    }
                    java.nio.file.Path path = Paths.get(dirPrefix, dirSuffix, "*");
                    DiskUtils.clearDirectory(path.toString());
                }
            }
            catch (IOException ex) {
                log.error((Object)"Could not clean up the old cached files", (Throwable)ex);
            }
        }
    }

    private void initializeMetrics() {
        cacheEvictionCount = this.metrics.counter(BookKeeperMetrics.CacheMetric.CACHE_EVICTION_COUNT.getMetricName());
        cacheInvalidationCount = this.metrics.counter(BookKeeperMetrics.CacheMetric.CACHE_INVALIDATION_COUNT.getMetricName());
        cacheExpiryCount = this.metrics.counter(BookKeeperMetrics.CacheMetric.CACHE_EXPIRY_COUNT.getMetricName());
        this.totalRequestCount = this.metrics.counter(BookKeeperMetrics.CacheMetric.TOTAL_REQUEST_COUNT.getMetricName());
        this.cacheRequestCount = this.metrics.counter(BookKeeperMetrics.CacheMetric.CACHE_REQUEST_COUNT.getMetricName());
        this.nonlocalRequestCount = this.metrics.counter(BookKeeperMetrics.CacheMetric.NONLOCAL_REQUEST_COUNT.getMetricName());
        this.remoteRequestCount = this.metrics.counter(BookKeeperMetrics.CacheMetric.REMOTE_REQUEST_COUNT.getMetricName());
        this.metrics.register(BookKeeperMetrics.CacheMetric.CACHE_HIT_RATE_GAUGE.getMetricName(), new Gauge<Double>(){

            @Override
            public Double getValue() {
                return ((double)BookKeeper.this.cacheRequestCount.getCount() + (double)BookKeeper.this.nonlocalRequestCount.getCount()) / (double)(BookKeeper.this.cacheRequestCount.getCount() + BookKeeper.this.remoteRequestCount.getCount() + BookKeeper.this.nonlocalRequestCount.getCount());
            }
        });
        this.metrics.register(BookKeeperMetrics.CacheMetric.CACHE_MISS_RATE_GAUGE.getMetricName(), new Gauge<Double>(){

            @Override
            public Double getValue() {
                return (double)BookKeeper.this.remoteRequestCount.getCount() / (double)(BookKeeper.this.cacheRequestCount.getCount() + BookKeeper.this.remoteRequestCount.getCount() + BookKeeper.this.nonlocalRequestCount.getCount());
            }
        });
        this.metrics.register(BookKeeperMetrics.CacheMetric.CACHE_SIZE_GAUGE.getMetricName(), new Gauge<Integer>(){

            @Override
            public Integer getValue() {
                return DiskUtils.getCacheSizeMB(BookKeeper.this.conf);
            }
        });
        this.metrics.register(BookKeeperMetrics.CacheMetric.CACHE_AVAILABLE_SIZE_GAUGE.getMetricName(), new Gauge<Long>(){

            @Override
            public Long getValue() {
                return totalAvailableForCacheInMB;
            }
        });
    }

    @Override
    public CacheStatusResponse getCacheStatus(CacheStatusRequest request) throws TException {
        FileMetadata md;
        try {
            this.initializeClusterManager(request);
        }
        catch (ClusterManagerInitilizationException ex) {
            log.error((Object)("Not able to initialize ClusterManager for cluster type : " + (Object)((Object)ClusterType.findByValue(request.getClusterType())) + " with Exception : " + ex));
            return null;
        }
        String currentNodeName = this.clusterManager.getCurrentNodeName();
        HashMap<Long, String> blockSplits = new HashMap<Long, String>();
        long blockNumber = 0L;
        long fileLength = request.getFileLength();
        String remotePath = request.getRemotePath();
        long lastModified = request.getLastModified();
        long startBlock = request.getStartBlock();
        long endBlock = request.getEndBlock();
        boolean incrMetrics = request.isIncrMetrics();
        for (long i = 0L; i < fileLength; i += this.splitSize) {
            long end = i + this.splitSize;
            if (end > fileLength) {
                end = fileLength;
            }
            String key = remotePath + i + end;
            String nodeAddress = this.clusterManager.locateKey(key);
            blockSplits.put(blockNumber, nodeAddress);
            ++blockNumber;
        }
        try {
            md = fileMetadataCache.get(remotePath, () -> new FileMetadata(remotePath, fileLength, lastModified, 0L, this.conf, this.generationNumberCache, this.fileAccessedBloomFilter));
            if (this.isInvalidationRequired(md.getLastModified(), lastModified)) {
                this.invalidateFileMetadata(remotePath);
                md = fileMetadataCache.get(remotePath, () -> new FileMetadata(remotePath, fileLength, lastModified, 0L, this.conf, this.generationNumberCache, this.fileAccessedBloomFilter));
            }
        }
        catch (ExecutionException e) {
            log.error((Object)String.format("Could not fetch Metadata for %s", remotePath), (Throwable)e);
            throw new TException(e);
        }
        endBlock = this.setCorrectEndBlock(endBlock, fileLength, remotePath);
        ArrayList<BlockLocation> blockLocations = new ArrayList<BlockLocation>((int)(endBlock - startBlock));
        int blockSize = CacheConfig.getBlockSize(this.conf);
        int totalRequests = 0;
        int cacheRequests = 0;
        int remoteRequests = 0;
        int nonLocalRequests = 0;
        try {
            for (long blockNum = startBlock; blockNum < endBlock; ++blockNum) {
                ++totalRequests;
                long split = blockNum * (long)blockSize / this.splitSize;
                if (!((String)blockSplits.get(split)).equals(currentNodeName)) {
                    blockLocations.add(new BlockLocation(Location.NON_LOCAL, (String)blockSplits.get(split)));
                    ++nonLocalRequests;
                    continue;
                }
                if (md.isBlockCached(blockNum)) {
                    blockLocations.add(new BlockLocation(Location.CACHED, (String)blockSplits.get(split)));
                    ++cacheRequests;
                    continue;
                }
                blockLocations.add(new BlockLocation(Location.LOCAL, (String)blockSplits.get(split)));
                ++remoteRequests;
            }
        }
        catch (IOException e) {
            throw new TException(e);
        }
        if (request.isIncrMetrics() && !BookKeeper.isValidatingCachingBehavior(remotePath)) {
            this.totalRequestCount.inc(totalRequests);
            this.nonlocalRequestCount.inc(nonLocalRequests);
            this.cacheRequestCount.inc(cacheRequests);
            this.remoteRequestCount.inc(remoteRequests);
        }
        return new CacheStatusResponse(blockLocations, md.getGenerationNumber());
    }

    public boolean isInitialized() {
        return this.clusterManager != null;
    }

    private void initializeClusterManager(CacheStatusRequest request) throws ClusterManagerInitilizationException {
        if (!this.isInitialized()) {
            Preconditions.checkState(request.isSetClusterType(), "Received getCacheStatus without clusterType before BookKeeper is initialized");
        }
        this.initializeClusterManager(request.getClusterType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void initializeClusterManager(int clusterType) throws ClusterManagerInitilizationException {
        if (!this.isInitialized()) {
            ClusterManager manager = null;
            Integer n = lock;
            synchronized (n) {
                if (!this.isInitialized()) {
                    manager = this.getClusterManagerInstance(ClusterType.findByValue(clusterType), this.conf);
                    try {
                        manager.initialize(this.conf);
                    }
                    catch (UnknownHostException e) {
                        throw new ClusterManagerInitilizationException("Unable to initialize cluster manager", e);
                    }
                    this.clusterManager = manager;
                }
            }
        }
    }

    @VisibleForTesting
    public ClusterManager getClusterManagerInstance(ClusterType clusterType, Configuration config) throws ClusterManagerInitilizationException {
        String clusterManagerClassName = CacheConfig.getClusterManagerClass(this.conf, clusterType);
        log.debug((Object)("Initializing cluster manager : " + clusterManagerClassName));
        ClusterManager manager = null;
        try {
            Class clusterManagerClass = this.conf.getClassByName(clusterManagerClassName);
            Constructor constructor = clusterManagerClass.getConstructor(new Class[0]);
            manager = (ClusterManager)constructor.newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            String errorMessage = String.format("Not able to initialize ClusterManager class : %s ", clusterManagerClassName);
            log.error((Object)errorMessage);
            throw new ClusterManagerInitilizationException(errorMessage, ex);
        }
        return manager;
    }

    @Override
    public void setAllCached(String remotePath, long fileLength, long lastModified, long startBlock, long endBlock, int generationNumber) throws TException {
        FileMetadata md = fileMetadataCache.getIfPresent(remotePath);
        if (md == null) {
            log.debug((Object)String.format("Could not update the metadata for file %s", remotePath));
            return;
        }
        if (md.getGenerationNumber() != generationNumber) {
            log.debug((Object)String.format("Could not update the metadata for file %s having different generationNumber %d in cache and %d in request", remotePath, md.getGenerationNumber(), generationNumber));
            return;
        }
        if (this.isInvalidationRequired(md.getLastModified(), lastModified)) {
            this.invalidateFileMetadata(remotePath);
            return;
        }
        endBlock = this.setCorrectEndBlock(endBlock, fileLength, remotePath);
        log.debug((Object)("Updating cache for " + remotePath + " StartBlock : " + startBlock + " EndBlock : " + endBlock));
        try {
            OptionalInt updatedBlocks = md.setBlocksCached(startBlock, endBlock);
            if (updatedBlocks.isPresent()) {
                long currentFileSize = md.incrementCurrentFileSize(updatedBlocks.getAsInt() * CacheConfig.getBlockSize(this.conf));
                currentFileSize = Math.min(currentFileSize, fileLength);
                this.replaceFileMetadata(remotePath, currentFileSize, this.conf);
            }
        }
        catch (IOException e) {
            throw new TException(e);
        }
    }

    @VisibleForTesting
    public long getTotalCacheWeight() {
        return fileMetadataCache.asMap().values().stream().mapToLong(FileMetadata::getWeight).sum();
    }

    @Override
    public Map<String, Double> getCacheMetrics() {
        ImmutableMap.Builder<String, Double> cacheMetrics = ImmutableMap.builder();
        fileMetadataCache.cleanUp();
        for (Map.Entry<String, Gauge> entry : this.metrics.getGauges(this.bookKeeperMetrics.getMetricsFilter()).entrySet()) {
            try {
                cacheMetrics.put(entry.getKey(), this.getGaugeValueAsDouble(entry.getValue().getValue()));
            }
            catch (ClassCastException e) {
                log.error((Object)String.format("Gauge metric %s is not a numeric value", entry.getKey()), (Throwable)e);
            }
        }
        for (Map.Entry<String, Metric> entry : this.metrics.getCounters(this.bookKeeperMetrics.getMetricsFilter()).entrySet()) {
            cacheMetrics.put(entry.getKey(), Double.valueOf(((Counter)entry.getValue()).getCount()));
        }
        return cacheMetrics.build();
    }

    @Override
    public Map<String, Long> getReadRequestChainStats() {
        ImmutableMap.Builder<String, Long> stats = ImmutableMap.builder();
        ReadRequestChainStats readRequestChainStats = warmupStats.getStats();
        if (CacheConfig.isParallelWarmupEnabled(this.conf)) {
            stats.put("downloaded_for_parallel_warmup", readRequestChainStats.getRemoteRRCDataRead());
            stats.put("parallel_download_time", readRequestChainStats.getRemoteRRCWarmupTime());
        } else {
            stats.put("downloaded_for_non_local", readRequestChainStats.getRemoteRRCDataRead());
            stats.put("extra_read_for_non_local", readRequestChainStats.getRemoteRRCExtraDataRead());
            stats.put("warmup_penalty_non_local", readRequestChainStats.getRemoteRRCWarmupTime());
        }
        return stats.build();
    }

    @Override
    public ReadResponse readData(String remotePath, long offset, int length, long fileSize, long lastModified, int clusterType) throws TException {
        if (CacheConfig.isParallelWarmupEnabled(this.conf)) {
            this.startRemoteFetchProcessor();
            log.debug((Object)("Adding to the queue Path : " + remotePath + " Offset : " + offset + " Length " + length));
            this.fetchProcessor.addToProcessQueue(remotePath, offset, length, fileSize, lastModified);
            return new ReadResponse(false, 0);
        }
        return this.readDataInternal(remotePath, offset, length, fileSize, lastModified, clusterType);
    }

    private synchronized void startRemoteFetchProcessor() {
        if (this.fetchProcessor.state() == Service.State.NEW) {
            this.fetchProcessor.startAsync();
        }
    }

    @Override
    public FileInfo getFileInfo(String remotePath) throws TException {
        try {
            return fileInfoCache.get(remotePath);
        }
        catch (ExecutionException e) {
            log.error((Object)String.format("Could not fetch FileInfo from Cache for %s", remotePath), (Throwable)e);
            throw new TException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReadResponse readDataInternal(String remotePath, long offset, int length, long fileSize, long lastModified, int clusterType) throws TException {
        int blockSize = CacheConfig.getBlockSize(this.conf);
        byte[] buffer = new byte[blockSize];
        FileSystem fs = null;
        FSDataInputStream inputStream = null;
        Path path = new Path(remotePath);
        long startBlock = offset / (long)blockSize;
        long endBlock = (offset + (long)(length - 1)) / (long)CacheConfig.getBlockSize(this.conf) + 1L;
        CacheStatusResponse response = null;
        try {
            int idx = 0;
            CacheStatusRequest request = new CacheStatusRequest(remotePath, fileSize, lastModified, startBlock, endBlock).setClusterType(clusterType);
            response = this.getCacheStatus(request);
            List<BlockLocation> blockLocations = response.getBlocks();
            long blockNum = startBlock;
            while (blockNum < endBlock) {
                long readStart = blockNum * (long)blockSize;
                log.debug((Object)(" blockLocation is: " + blockLocations.get(idx).getLocation() + " for path " + remotePath + " offset " + offset + " length " + length));
                if (blockLocations.get(idx).getLocation() != Location.CACHED) {
                    if (fs == null) {
                        fs = path.getFileSystem(this.conf);
                        fs.initialize(path.toUri(), this.conf);
                        inputStream = fs.open(path, blockSize);
                    }
                    long expectedBytesToRead = readStart + (long)blockSize > fileSize ? fileSize - readStart : (long)blockSize;
                    RemoteReadRequestChain remoteReadRequestChain = new RemoteReadRequestChain(inputStream, remotePath, response.getGenerationNumber(), bufferPool, this.conf, buffer, new BookKeeperFactory(this));
                    remoteReadRequestChain.addReadRequest(new ReadRequest(readStart, readStart + expectedBytesToRead, readStart, readStart + expectedBytesToRead, buffer, 0, fileSize));
                    remoteReadRequestChain.lock();
                    long dataRead = remoteReadRequestChain.call();
                    if (dataRead == expectedBytesToRead) {
                        remoteReadRequestChain.updateCacheStatus(remotePath, fileSize, lastModified, blockSize, this.conf);
                        warmupStats.addReadRequestChainStats(remoteReadRequestChain.getStats());
                    } else {
                        log.error((Object)("Not able to download requested bytes. Not updating the cache for block " + blockNum));
                        ReadResponse readResponse = new ReadResponse(false, response.getGenerationNumber());
                        return readResponse;
                    }
                }
                ++blockNum;
                ++idx;
            }
            ReadResponse readResponse = new ReadResponse(true, response.getGenerationNumber());
            return readResponse;
        }
        catch (Exception e) {
            log.warn((Object)"Could not cache data: ", (Throwable)e);
            ReadResponse readResponse = new ReadResponse(false, response.getGenerationNumber());
            return readResponse;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.error((Object)"Error closing inputStream", (Throwable)e);
                }
            }
        }
    }

    private long setCorrectEndBlock(long endBlock, long fileLength, String remotePath) {
        long lastBlock = (fileLength - 1L) / (long)CacheConfig.getBlockSize(this.conf);
        if (endBlock > lastBlock + 1L) {
            endBlock = lastBlock + 1L;
        }
        return endBlock;
    }

    private synchronized void initializeCache(Configuration conf, Ticker ticker) throws FileNotFoundException {
        if (CacheConfig.isOnMaster(conf) && !CacheConfig.isCacheDataOnMasterEnabled(conf)) {
            log.info((Object)"Cache disabled on master node; skipping initialization");
            totalAvailableForCacheInMB = 0L;
            fileInfoCache = CacheBuilder.newBuilder().build(new CacheLoader<String, FileInfo>(){

                @Override
                public FileInfo load(String key) throws Exception {
                    throw new UnsupportedOperationException(String.format("unexpected load call for key %s; cache disabled on master node", key));
                }
            });
            fileMetadataCache = new ThrowingEmptyCache<String, FileMetadata>();
            return;
        }
        CacheUtil.createCacheDirectories(conf);
        int cacheDiskCount = CacheUtil.getCacheDiskCount(conf);
        if (cacheDiskCount == 0) {
            throw new IllegalStateException("No disks available for caching");
        }
        long avail = 0L;
        for (int d = 0; d < cacheDiskCount; ++d) {
            avail += new File(CacheUtil.getDirPath(d, conf)).getUsableSpace();
        }
        avail = DataSizeUnits.BYTES.toMB(avail);
        long totalUsableMBs = (long)(0.95 * (double)avail);
        long cacheMaxSizeInMB = CacheConfig.getCacheDataFullnessMaxSizeInMB(conf);
        totalAvailableForCacheInMB = cacheMaxSizeInMB == 0L ? (long)((double)totalUsableMBs * 1.0 * (double)CacheConfig.getCacheDataFullnessPercentage(conf) / 100.0) : cacheMaxSizeInMB;
        log.info((Object)("total free space " + avail + "MB, maximum size of cache " + totalAvailableForCacheInMB + "MB"));
        BookKeeper.initializeFileInfoCache(conf, ticker);
        fileMetadataCache = CacheBuilder.newBuilder().ticker(ticker).weigher((key, md) -> md.getWeight()).maximumWeight(DataSizeUnits.MEGABYTES.toKB(totalAvailableForCacheInMB)).expireAfterWrite(CacheConfig.getCacheDataExpirationAfterWrite(conf), TimeUnit.MILLISECONDS).removalListener(new CacheRemovalListener()).build();
        this.fileAccessedBloomFilter = BloomFilter.create(Funnels.stringFunnel(Charset.defaultCharset()), 1000000, 0.01);
        this.generationNumberCache = CacheBuilder.newBuilder().expireAfterAccess(2L, TimeUnit.HOURS).build();
    }

    @VisibleForTesting
    public FileMetadata getFileMetadata(String key) {
        return fileMetadataCache.getIfPresent(key);
    }

    private static void initializeFileInfoCache(final Configuration conf, Ticker ticker) {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        int expiryPeriod = CacheConfig.getStaleFileInfoExpiryPeriod(conf);
        fileInfoCache = CacheBuilder.newBuilder().ticker(ticker).expireAfterWrite(expiryPeriod, TimeUnit.SECONDS).removalListener(new RemovalListener<String, FileInfo>(){

            @Override
            public void onRemoval(RemovalNotification<String, FileInfo> notification) {
                log.debug((Object)("Removed FileInfo for path " + (String)notification.getKey() + " due to " + (Object)((Object)notification.getCause())));
            }
        }).build(CacheLoader.asyncReloading(new CacheLoader<String, FileInfo>(){

            @Override
            public FileInfo load(String s) throws Exception {
                Path path = new Path(s);
                FileSystem fs = path.getFileSystem(conf);
                FileStatus status = fs.getFileStatus(path);
                FileInfo info = new FileInfo(status.getLen(), status.getModificationTime());
                return info;
            }
        }, executor));
    }

    @Override
    public void invalidateFileMetadata(String key) {
        if (fileMetadataCache != null) {
            fileMetadataCache.invalidate(key);
        }
    }

    private void replaceFileMetadata(String key, long currentFileSize, Configuration conf) {
        FileMetadata metadata;
        if (fileMetadataCache != null && (metadata = fileMetadataCache.getIfPresent(key)) != null) {
            FileMetadata newMetaData = new FileMetadata(key, metadata.getFileSize(), metadata.getLastModified(), currentFileSize, conf, metadata.getGenerationNumber());
            fileMetadataCache.put(key, newMetaData);
        }
    }

    private boolean isInvalidationRequired(long metadataLastModifiedTime, long remoteLastModifiedTime) {
        return CacheConfig.isFileStalenessCheckEnabled(this.conf) && metadataLastModifiedTime != remoteLastModifiedTime;
    }

    private static boolean isValidatingCachingBehavior(String remotePath) {
        return "rubixCachingTestFile".equals(CacheUtil.getName(remotePath));
    }

    private double getGaugeValueAsDouble(Object gaugeValue) {
        if (gaugeValue instanceof Long) {
            return ((Long)gaugeValue).doubleValue();
        }
        if (gaugeValue instanceof Integer) {
            return ((Integer)gaugeValue).doubleValue();
        }
        if (Double.isNaN((Double)gaugeValue)) {
            return Double.NaN;
        }
        throw new ClassCastException("Could not cast gauge metric value type to Double");
    }

    static {
        lock = 1;
    }

    protected static class CacheRemovalListener
    implements RemovalListener<String, FileMetadata> {
        protected CacheRemovalListener() {
        }

        @Override
        public void onRemoval(RemovalNotification<String, FileMetadata> notification) {
            FileMetadata md = (FileMetadata)notification.getValue();
            md.closeAndCleanup(notification.getCause(), fileMetadataCache);
            if (!BookKeeper.isValidatingCachingBehavior(md.getRemotePath())) {
                switch (notification.getCause()) {
                    case EXPLICIT: {
                        cacheInvalidationCount.inc();
                        break;
                    }
                    case SIZE: {
                        cacheEvictionCount.inc();
                        break;
                    }
                    case EXPIRED: {
                        cacheExpiryCount.inc();
                        break;
                    }
                }
            }
        }
    }
}

