/*
 * Decompiled with CFR 0.152.
 */
package info.ganglia.gmetric4j.gmetric;

import info.ganglia.gmetric4j.gmetric.GMetric;
import info.ganglia.gmetric4j.gmetric.GMetricSlope;
import info.ganglia.gmetric4j.gmetric.GMetricType;
import info.ganglia.gmetric4j.gmetric.Protocol;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractProtocol
implements Protocol {
    protected InetAddress udpAddr = null;
    protected int port;
    protected String group;
    private DatagramSocket socket;
    private int ttl;
    private GMetric.UDPAddressingMode mode;
    private static Logger log = Logger.getLogger(AbstractProtocol.class.getName());

    public AbstractProtocol(String group, int port, GMetric.UDPAddressingMode mode, int ttl) {
        this.group = group;
        this.port = port;
        this.mode = mode;
        this.ttl = ttl;
    }

    protected void send(byte[] buf, int len) throws Exception {
        if (this.udpAddr == null) {
            this.udpAddr = InetAddress.getByName(this.group);
        }
        DatagramPacket packet = new DatagramPacket(buf, len, this.udpAddr, this.port);
        if (this.socket == null) {
            if (this.mode == GMetric.UDPAddressingMode.MULTICAST) {
                MulticastSocket multicastSocket = new MulticastSocket();
                multicastSocket.setTimeToLive(this.ttl);
                this.socket = multicastSocket;
            } else {
                this.socket = new DatagramSocket();
            }
        }
        log.log(Level.FINEST, "Sending message of length " + len);
        this.socket.send(packet);
    }

    public abstract void announce(String var1, String var2, GMetricType var3, String var4, GMetricSlope var5, int var6, int var7, String var8) throws Exception;
}

