/*
 * Decompiled with CFR 0.152.
 */
package io.trino.orc;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import io.airlift.slice.FixedLengthSliceInput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceInput;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import java.util.function.Supplier;
import org.openjdk.jol.info.ClassLayout;

final class LazySliceInput
extends FixedLengthSliceInput {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(LazySliceInput.class).instanceSize();
    private final int globalLength;
    private final Supplier<FixedLengthSliceInput> loader;
    private int initialPosition;
    private FixedLengthSliceInput delegate;

    public LazySliceInput(long globalLength, Supplier<FixedLengthSliceInput> loader) {
        Preconditions.checkArgument((globalLength > 0L ? 1 : 0) != 0, (Object)"globalLength must be at least 1");
        Preconditions.checkArgument((globalLength <= Integer.MAX_VALUE ? 1 : 0) != 0, (Object)"globalLength must be less than 2GB");
        this.globalLength = Math.toIntExact(globalLength);
        this.loader = Objects.requireNonNull(loader, "loader is null");
    }

    private SliceInput getDelegate() {
        if (this.delegate == null) {
            this.delegate = Objects.requireNonNull(this.loader.get(), "loader returned a null stream");
            Verify.verify((this.delegate.length() == (long)this.globalLength ? 1 : 0) != 0, (String)"loader returned stream of length %s, but length %s was expected", (long)this.delegate.length(), (int)this.globalLength);
            this.delegate.setPosition((long)this.initialPosition);
        }
        return this.delegate;
    }

    public long length() {
        return this.globalLength;
    }

    public long position() {
        if (this.delegate == null) {
            return this.initialPosition;
        }
        return this.delegate.position();
    }

    public void setPosition(long position) {
        if (this.delegate == null) {
            if (position < 0L || position > (long)this.globalLength) {
                throw new IndexOutOfBoundsException("Invalid position " + position + " for slice with length " + this.globalLength);
            }
            this.initialPosition = Math.toIntExact(position);
            return;
        }
        this.delegate.setPosition(position);
    }

    public boolean isReadable() {
        if (this.delegate == null) {
            return true;
        }
        return this.delegate.isReadable();
    }

    public int available() {
        if (this.delegate == null) {
            return this.globalLength;
        }
        return this.delegate.available();
    }

    public int read() {
        return this.getDelegate().read();
    }

    public boolean readBoolean() {
        return this.getDelegate().readBoolean();
    }

    public byte readByte() {
        return this.getDelegate().readByte();
    }

    public int readUnsignedByte() {
        return this.getDelegate().readUnsignedByte();
    }

    public short readShort() {
        return this.getDelegate().readShort();
    }

    public int readUnsignedShort() {
        return this.getDelegate().readUnsignedShort();
    }

    public int readInt() {
        return this.getDelegate().readInt();
    }

    public long readLong() {
        return this.getDelegate().readLong();
    }

    public float readFloat() {
        return this.getDelegate().readFloat();
    }

    public double readDouble() {
        return this.getDelegate().readDouble();
    }

    public Slice readSlice(int length) {
        return this.getDelegate().readSlice(length);
    }

    public int read(byte[] destination, int destinationIndex, int length) {
        return this.getDelegate().read(destination, destinationIndex, length);
    }

    public void readBytes(byte[] destination, int destinationIndex, int length) {
        this.getDelegate().readBytes(destination, destinationIndex, length);
    }

    public void readBytes(Slice destination, int destinationIndex, int length) {
        this.getDelegate().readBytes(destination, destinationIndex, length);
    }

    public void readBytes(OutputStream out, int length) throws IOException {
        this.getDelegate().readBytes(out, length);
    }

    public long skip(long length) {
        return this.getDelegate().skip(length);
    }

    public int skipBytes(int length) {
        return this.getDelegate().skipBytes(length);
    }

    public long getRetainedSize() {
        return (long)INSTANCE_SIZE + this.getDelegate().getRetainedSize();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("globalLength", this.globalLength).add("loaded", this.delegate != null).toString();
    }
}

