/*
 * Decompiled with CFR 0.152.
 */
package io.trino.rcfile.text;

import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import io.trino.rcfile.ColumnData;
import io.trino.rcfile.EncodeOutput;
import io.trino.rcfile.text.TextColumnEncoding;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.Type;
import java.util.Base64;

public class BinaryEncoding
implements TextColumnEncoding {
    private static final Base64.Decoder base64Decoder = Base64.getDecoder();
    private static final Base64.Encoder base64Encoder = Base64.getEncoder();
    private final Type type;
    private final Slice nullSequence;

    public BinaryEncoding(Type type, Slice nullSequence) {
        this.type = type;
        this.nullSequence = nullSequence;
    }

    @Override
    public void encodeColumn(Block block, SliceOutput output, EncodeOutput encodeOutput) {
        for (int position = 0; position < block.getPositionCount(); ++position) {
            if (block.isNull(position)) {
                output.writeBytes(this.nullSequence);
            } else {
                Slice slice = this.type.getSlice(block, position);
                byte[] data = slice.getBytes();
                slice = Slices.wrappedBuffer((byte[])base64Encoder.encode(data));
                output.writeBytes(slice);
            }
            encodeOutput.closeEntry();
        }
    }

    @Override
    public void encodeValueInto(int depth, Block block, int position, SliceOutput output) {
        Slice slice = this.type.getSlice(block, position);
        byte[] data = slice.getBytes();
        slice = Slices.wrappedBuffer((byte[])base64Encoder.encode(data));
        output.writeBytes(slice);
    }

    @Override
    public Block decodeColumn(ColumnData columnData) {
        int size = columnData.rowCount();
        BlockBuilder builder = this.type.createBlockBuilder(null, size);
        Slice slice = columnData.getSlice();
        for (int i = 0; i < size; ++i) {
            int offset = columnData.getOffset(i);
            int length = columnData.getLength(i);
            if (this.nullSequence.equals(0, this.nullSequence.length(), slice, offset, length)) {
                builder.appendNull();
                continue;
            }
            byte[] data = slice.getBytes(offset, length);
            this.type.writeSlice(builder, Slices.wrappedBuffer((byte[])base64Decoder.decode(data)));
        }
        return builder.build();
    }

    @Override
    public void decodeValueInto(int depth, BlockBuilder builder, Slice slice, int offset, int length) {
        byte[] data = slice.getBytes(offset, length);
        this.type.writeSlice(builder, Slices.wrappedBuffer((byte[])base64Decoder.decode(data)));
    }
}

