/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.phoenix;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.multibindings.OptionalBinder;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConfigBinder;
import io.trino.plugin.base.classloader.ClassLoaderSafeConnectorMetadata;
import io.trino.plugin.base.classloader.ClassLoaderSafeConnectorPageSinkProvider;
import io.trino.plugin.base.classloader.ClassLoaderSafeConnectorRecordSetProvider;
import io.trino.plugin.base.classloader.ClassLoaderSafeConnectorSplitManager;
import io.trino.plugin.base.classloader.ForClassLoaderSafe;
import io.trino.plugin.jdbc.ConfiguringConnectionFactory;
import io.trino.plugin.jdbc.ConnectionFactory;
import io.trino.plugin.jdbc.DecimalModule;
import io.trino.plugin.jdbc.DefaultQueryBuilder;
import io.trino.plugin.jdbc.DriverConnectionFactory;
import io.trino.plugin.jdbc.ForBaseJdbc;
import io.trino.plugin.jdbc.ForLazyConnectionFactory;
import io.trino.plugin.jdbc.ForRecordCursor;
import io.trino.plugin.jdbc.JdbcClient;
import io.trino.plugin.jdbc.JdbcDiagnosticModule;
import io.trino.plugin.jdbc.JdbcMetadataConfig;
import io.trino.plugin.jdbc.JdbcMetadataSessionProperties;
import io.trino.plugin.jdbc.JdbcModule;
import io.trino.plugin.jdbc.JdbcPageSinkProvider;
import io.trino.plugin.jdbc.JdbcRecordSetProvider;
import io.trino.plugin.jdbc.JdbcWriteConfig;
import io.trino.plugin.jdbc.JdbcWriteSessionProperties;
import io.trino.plugin.jdbc.LazyConnectionFactory;
import io.trino.plugin.jdbc.MaxDomainCompactionThreshold;
import io.trino.plugin.jdbc.QueryBuilder;
import io.trino.plugin.jdbc.StatsCollecting;
import io.trino.plugin.jdbc.TypeHandlingJdbcConfig;
import io.trino.plugin.jdbc.TypeHandlingJdbcSessionProperties;
import io.trino.plugin.jdbc.credential.CredentialProvider;
import io.trino.plugin.jdbc.credential.EmptyCredentialProvider;
import io.trino.plugin.jdbc.mapping.IdentifierMappingModule;
import io.trino.plugin.phoenix.PhoenixClient;
import io.trino.plugin.phoenix.PhoenixColumnProperties;
import io.trino.plugin.phoenix.PhoenixConfig;
import io.trino.plugin.phoenix.PhoenixConnector;
import io.trino.plugin.phoenix.PhoenixErrorCode;
import io.trino.plugin.phoenix.PhoenixMetadata;
import io.trino.plugin.phoenix.PhoenixSessionProperties;
import io.trino.plugin.phoenix.PhoenixSplitManager;
import io.trino.plugin.phoenix.PhoenixTableProperties;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorPageSinkProvider;
import io.trino.spi.connector.ConnectorRecordSetProvider;
import io.trino.spi.connector.ConnectorSplitManager;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import javax.annotation.PreDestroy;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.phoenix.jdbc.PhoenixDriver;
import org.apache.phoenix.jdbc.PhoenixEmbeddedDriver;

public class PhoenixClientModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        binder.bind(ConnectorSplitManager.class).annotatedWith(ForClassLoaderSafe.class).to(PhoenixSplitManager.class).in(Scopes.SINGLETON);
        binder.bind(ConnectorSplitManager.class).to(ClassLoaderSafeConnectorSplitManager.class).in(Scopes.SINGLETON);
        binder.bind(ConnectorRecordSetProvider.class).annotatedWith(ForClassLoaderSafe.class).to(JdbcRecordSetProvider.class).in(Scopes.SINGLETON);
        binder.bind(ConnectorRecordSetProvider.class).to(ClassLoaderSafeConnectorRecordSetProvider.class).in(Scopes.SINGLETON);
        binder.bind(ConnectorPageSinkProvider.class).annotatedWith(ForClassLoaderSafe.class).to(JdbcPageSinkProvider.class).in(Scopes.SINGLETON);
        binder.bind(ConnectorPageSinkProvider.class).to(ClassLoaderSafeConnectorPageSinkProvider.class).in(Scopes.SINGLETON);
        binder.bind(QueryBuilder.class).to(DefaultQueryBuilder.class).in(Scopes.SINGLETON);
        OptionalBinder.newOptionalBinder((Binder)binder, (Key)Key.get(Integer.TYPE, MaxDomainCompactionThreshold.class));
        ConfigBinder.configBinder((Binder)binder).bindConfig(TypeHandlingJdbcConfig.class);
        JdbcModule.bindSessionPropertiesProvider((Binder)binder, TypeHandlingJdbcSessionProperties.class);
        JdbcModule.bindSessionPropertiesProvider((Binder)binder, JdbcMetadataSessionProperties.class);
        JdbcModule.bindSessionPropertiesProvider((Binder)binder, JdbcWriteSessionProperties.class);
        JdbcModule.bindSessionPropertiesProvider((Binder)binder, PhoenixSessionProperties.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(JdbcMetadataConfig.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(JdbcWriteConfig.class);
        binder.bind(PhoenixClient.class).in(Scopes.SINGLETON);
        binder.bind(JdbcClient.class).annotatedWith(ForBaseJdbc.class).to(Key.get(PhoenixClient.class)).in(Scopes.SINGLETON);
        binder.bind(JdbcClient.class).to(Key.get(JdbcClient.class, StatsCollecting.class)).in(Scopes.SINGLETON);
        binder.bind(ConnectorMetadata.class).annotatedWith(ForClassLoaderSafe.class).to(PhoenixMetadata.class).in(Scopes.SINGLETON);
        binder.bind(ConnectorMetadata.class).to(ClassLoaderSafeConnectorMetadata.class).in(Scopes.SINGLETON);
        binder.bind(ConnectionFactory.class).annotatedWith(ForLazyConnectionFactory.class).to(Key.get(ConnectionFactory.class, StatsCollecting.class)).in(Scopes.SINGLETON);
        binder.bind(ConnectionFactory.class).to(LazyConnectionFactory.class).in(Scopes.SINGLETON);
        JdbcModule.bindTablePropertiesProvider((Binder)binder, PhoenixTableProperties.class);
        binder.bind(PhoenixColumnProperties.class).in(Scopes.SINGLETON);
        binder.bind(PhoenixConnector.class).in(Scopes.SINGLETON);
        this.checkConfiguration(((PhoenixConfig)this.buildConfigObject(PhoenixConfig.class)).getConnectionUrl());
        this.install((Module)new JdbcDiagnosticModule());
        this.install((Module)new IdentifierMappingModule());
        this.install((Module)new DecimalModule());
    }

    private void checkConfiguration(String connectionUrl) {
        try {
            PhoenixDriver driver = PhoenixDriver.INSTANCE;
            Preconditions.checkArgument((boolean)driver.acceptsURL(connectionUrl), (Object)"Invalid JDBC URL for Phoenix connector");
        }
        catch (SQLException e) {
            throw new TrinoException((ErrorCodeSupplier)PhoenixErrorCode.PHOENIX_CONFIG_ERROR, (Throwable)e);
        }
    }

    @Provides
    @Singleton
    @ForBaseJdbc
    public ConnectionFactory getConnectionFactory(PhoenixConfig config) throws SQLException {
        return new ConfiguringConnectionFactory((ConnectionFactory)new DriverConnectionFactory((Driver)PhoenixDriver.INSTANCE, config.getConnectionUrl(), PhoenixClientModule.getConnectionProperties(config), (CredentialProvider)new EmptyCredentialProvider()), connection -> connection.setAutoCommit(true));
    }

    public static Properties getConnectionProperties(PhoenixConfig config) throws SQLException {
        Configuration resourcesConfig = PhoenixClientModule.readConfig(config);
        Properties connectionProperties = new Properties();
        for (Map.Entry entry : resourcesConfig) {
            connectionProperties.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        PhoenixEmbeddedDriver.ConnectionInfo connectionInfo = PhoenixEmbeddedDriver.ConnectionInfo.create((String)config.getConnectionUrl());
        connectionInfo.asProps().asMap().forEach(connectionProperties::setProperty);
        return connectionProperties;
    }

    private static Configuration readConfig(PhoenixConfig config) {
        Configuration result = new Configuration(false);
        for (String resourcePath : config.getResourceConfigFiles()) {
            result.addResource(new Path(resourcePath));
        }
        return result;
    }

    @Singleton
    @ForRecordCursor
    @Provides
    public ExecutorService createRecordCursorExecutor() {
        return MoreExecutors.newDirectExecutorService();
    }

    @PreDestroy
    public void shutdownRecordCursorExecutor(@ForRecordCursor ExecutorService executor) {
        executor.shutdownNow();
    }
}

